<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//    Copyright (C) 2010 Matteo Lucarelli
//    Copyright (C) 2011-2013 Uwe Steinmann
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//    Translators: Admin (3091), dgrutsch (22)

$text = array(
'2_factor_auth' => '2-Faktor Authentifizierung',
'2_factor_auth_info' => 'Dieses System erfordert 2-Faktor-Authentifikation. Dazu brauchen Sie den Google Authenticator auf Ihrem Mobiltelefon. Unten sehen Sie zwei QR-Codes. Der rechte Code beinhaltet Ihren aktuellen geheimen Schlüssel. Auf der linken Seite wird ein neuer Schlüssel angezeigt. Wenn Sie den neuen Schlüssel speichern, dann stellen Sie zuvor sicher, dass sie ihn mit dem Google Authenticator zuvor eingescant haben.',
'2_fact_auth_current_secret' => 'Aktuelles Geheimnis',
'2_fact_auth_new_secret' => 'Neues Geheimnis',
'2_fact_auth_secret' => 'Schlüssel',
'abbr_day' => 'T.',
'abbr_hour' => 'St.',
'abbr_minute' => 'Min.',
'abbr_month' => 'M.',
'abbr_second' => 'Sek.',
'abbr_week' => 'W.',
'abbr_year' => 'J.',
'accept' => 'Übernehmen',
'access_control' => 'Zugriffskontrolle',
'access_control_is_off' => 'Erweiterte Zugriffskontrolle ist ausgeschaltet',
'access_denied' => 'Zugriff verweigert',
'access_inheritance' => 'Zugriff vererben',
'access_mode' => 'Berechtigung',
'access_mode_all' => 'Keine Beschränkung',
'access_mode_none' => 'Kein Zugriff',
'access_mode_read' => 'Lesen',
'access_mode_readwrite' => 'Lesen+Schreiben',
'access_permission_changed_email' => 'Zugriffsrechte geändert',
'access_permission_changed_email_body' => 'Zugriffsrechte geändert

Dokument: [name]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'access_permission_changed_email_body_html' => '<p>Zugriffsrechte geändert</p>

<p>Dokument: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'access_permission_changed_email_subject' => '[sitename]: [name] - Zugriffsrechte geändert',
'according_settings' => 'Gemäß Einstellungen',
'action' => 'Aktivität',
'actions' => 'Aktivitäten',
'action_approve' => 'Freigeben',
'action_complete' => 'Komplett',
'action_is_complete' => 'Ist komplett',
'action_is_not_complete' => 'Ist nicht komplett',
'action_reject' => 'Ablehnen',
'action_review' => 'Prüfen',
'action_revise' => 'Erneut prüfen',
'add' => 'Anlegen',
'add_approval' => 'Freigabe hinzufügen',
'add_attrdefgroup' => 'Neue Attributgruppe anlegen',
'add_document' => 'Neues Dokument',
'add_document_link' => 'Verknüpfung hinzufügen',
'add_document_notify' => 'Beobachter zuweisen',
'add_doc_reviewer_approver_warning' => 'Anmerkung: Dokumente werden automatisch geprüft und als freigegeben markiert, wenn kein Prüfer oder keine Freigabe zugewiesen wird.',
'add_doc_workflow_warning' => 'Anmerkung: Dokumente werden automatisch freigegeben, wenn kein Workflow gewählt wird.',
'add_event' => 'Ereignis hinzufügen',
'add_group' => 'Neue Gruppe anlegen',
'add_member' => 'Gruppenmitglied anlegen',
'add_multiple_documents' => 'Mehrere Dokumente anlegen',
'add_multiple_files' => 'Mehrere Dateien hochladen (Dateiname wird als Dokumentenname verwendet)',
'add_receipt' => 'Empfang bestätigen',
'add_review' => 'Prüfung hinzufügen',
'add_revision' => 'Wiederholungsprüfung hinzufügen',
'add_role' => 'Neue Rolle anlegen',
'add_subfolder' => 'Neuer Ordner',
'add_task' => 'Neue Task für diese Klasse hinzufügen',
'add_to_clipboard' => 'Zur Zwischenablage hinzufügen',
'add_to_transmittal' => 'Zur Dokumentenliste hinzufügen',
'add_transmittal' => 'Dokumentenliste hinzufügen',
'add_user' => 'Neuen Benutzer anlegen',
'add_user_to_group' => 'Benutzer in Gruppe einfügen',
'add_workflow' => 'Neuen Workflow anlegen',
'add_workflow_action' => 'Neue Workflow-Aktion anlegen',
'add_workflow_state' => 'Neuen Workflow-Status anlegen',
'admin' => 'Administrator',
'admin_tools' => 'Administration',
'all' => 'Alle',
'all_categories' => 'Alle Kategorien',
'all_documents' => 'Alle Dokumente',
'all_pages' => 'Alle',
'all_users' => 'Alle Benutzer',
'already_subscribed' => 'Bereits abonniert',
'and' => 'und',
'apikey' => 'API-Schlüssel',
'apply' => 'Anwenden',
'approvals_accepted' => '[no_approvals] Freigaben',
'approvals_accepted_latest' => '(davon [no_approvals] in letzter Version)',
'approvals_and_reviews_accepted' => '[no_approvals] Freigaben und [no_reviews] Prüfungen',
'approvals_and_reviews_not_touched' => '[no_approvals] offene Freigaben und [no_reviews] offene Prüfungen',
'approvals_and_reviews_rejected' => '[no_approvals] abgelehnte Freigaben und [no_reviews] abgelehnte Prüfungen',
'approvals_not_touched' => '[no_approvals] offene Freigaben',
'approvals_not_touched_latest' => '(davon [no_approvals] in letzter Version)',
'approvals_rejected' => '[no_approvals] abgelehnte Freigaben',
'approvals_rejected_latest' => '(davon [no_approvals] in letzter Version)',
'approvals_without_group' => 'Freigaben ohne Gruppe',
'approvals_without_user' => 'Freigaben ohne Benutzer',
'approval_deletion_email' => 'Freigabeaufforderung gelöscht',
'approval_deletion_email_body' => 'Freigabeaufforderung gelöscht

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'approval_deletion_email_body_html' => '<p>Freigabeaufforderung gelöscht</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'approval_deletion_email_subject' => '[sitename]: [name] - Freigabeaufforderung gelöscht',
'approval_file' => 'Datei',
'approval_group' => 'Berechtigungsgruppe',
'approval_log' => 'Freigabeprotokoll',
'approval_request_email' => 'Aufforderung zur Freigabe',
'approval_request_email_body' => 'Aufforderung zur Freigabe

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'approval_request_email_body_html' => '<p>Aufforderung zur Freigabe</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'approval_request_email_subject' => '[sitename]: [name] - Aufforderung zur Freigabe',
'approval_status' => 'Freigabestatus',
'approval_submit_email' => '',
'approval_submit_email_body' => 'Freigabe erteilt

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Status: [status]
Kommentar: [comment]
Benutzer: [username]
URL: [url]',
'approval_submit_email_body_html' => '<p>Freigabe erteilt</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Status: [status]<br />
Kommentar: [comment]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'approval_submit_email_subject' => '[sitename]: [name] - Freigabe erteilt',
'approval_summary' => 'Übersicht Freigaben',
'approval_update_failed' => 'Störung bei der Aktualisierung des Berechtigungsstatus. Aktualisierung gescheitert',
'approvers' => 'Freigebender',
'approver_already_assigned' => 'Freigeber bereits zugewiesen',
'approver_already_removed' => 'Freigeber wurde bereits aus dem Freigabevorgang entfernt oder hat die Freigabe bereits abgeschlossen',
'april' => 'April',
'archive' => 'Archiv',
'archive_creation' => 'Archiv erzeugen',
'archive_creation_warning' => 'Mit dieser Operation können Sie ein Archiv mit allen Dokumenten des DMS erzeugen. Nach der Erstellung wird das Archiv im Datenordner Ihres Servers gespeichert.<br />Warnung: ein menschenlesbares Archiv ist als Server-Backup unbrauchbar.',
'ar_EG' => 'Arabisch',
'assign_approvers' => 'Freigebende zuweisen',
'assign_recipients' => 'Empfänger zuweisen',
'assign_reviewers' => 'Prüfer zuweisen',
'assign_user_property_to' => 'Dokumente einem anderen Benutzer zuweisen',
'assumed_released' => 'Angenommen, freigegeben',
'attrdefgroup_management' => 'Attributgruppenverwaltung',
'attrdefgrp_show_detail' => 'Details',
'attrdefgrp_show_list' => 'Liste',
'attrdefgrp_show_search' => 'Suche',
'attrdefgrp_show_searchlist' => 'Suchergebnis',
'attrdef_exists' => 'Attributdefinition existiert bereits',
'attrdef_info' => 'Information',
'attrdef_invalid_regex' => 'Fehlerhafter regulärer Ausdruck',
'attrdef_in_use' => 'Definition des Attributs noch in Gebrauch',
'attrdef_management' => 'Attributdefinitions-Management',
'attrdef_maxvalues' => 'Max. Anzahl Werte',
'attrdef_minvalues' => 'Min. Anzahl Werte',
'attrdef_minvalues_help' => 'Minimale Anzahl der Werte. Setzen Sie diesen Wert auf 1, wenn ein Attribut gesetzt werden muss.',
'attrdef_min_greater_max' => 'Zahl der minimalen Werte ist größer als Zahl der maximalen Werte',
'attrdef_multiple' => 'Mehrfachwerte erlaubt',
'attrdef_multiple_needs_valueset' => 'Attributdefinition mit Mehrfachwerten erfordert eine Werteliste.',
'attrdef_must_be_multiple' => 'Attribut muss mehr als einen Wert haben, erlaubt aber keine Mehrfachwerte',
'attrdef_name' => 'Name',
'attrdef_noname' => 'Kein Name für die Attributedefinition eingegeben',
'attrdef_objtype' => 'Objekttyp',
'attrdef_regex' => 'Regulärer Ausdruck',
'attrdef_regex_help' => 'Regulärer Ausdruck, der beim Typ Zeichenkette auf den Wert zutreffen muss.',
'attrdef_type' => 'Typ',
'attrdef_type_boolean' => 'Boolean',
'attrdef_type_date' => 'Datum',
'attrdef_type_document' => 'Dokument',
'attrdef_type_email' => 'E-Mail',
'attrdef_type_float' => 'Dezimalzahl',
'attrdef_type_folder' => 'Ordner',
'attrdef_type_group' => 'Gruppe',
'attrdef_type_int' => 'Ganzahlig',
'attrdef_type_string' => 'Zeichenkette',
'attrdef_type_url' => 'URL',
'attrdef_type_user' => 'Benutzer',
'attrdef_valueset' => 'Werteauswahl',
'attrdef_valueset_help' => 'Eine Liste von Werten, durch ein beliebiges Zeichen getrennt, welches auch am Anfang dieer Zeichenkette stehen muss, z.B. #ja#nein#vielleicht',
'attributes' => 'Attribute',
'attribute_changed_email_body' => 'Attribut geändert

Dokument: [name]
Version: [version]
Attribut: [attribute_name]
Alter Wert: [attribute_old_value]
Neuer Wert: [attribute_new_value]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'attribute_changed_email_body_html' => '<p>Attribut geändert</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Attribut: [attribute_name]<br />
Alter Wert: [attribute_old_value]<br />
Neuer Wert: [attribute_new_value]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'attribute_changed_email_subject' => '[sitename]: [name] - Attribut geändert',
'attribute_count' => 'Anzahl Verwendungen',
'attribute_value' => 'Attributwert',
'attribute_value_not_in_valueset' => 'Wert nicht im Wertebereich',
'attr_malformed_boolean' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist kein gültiger Ja/Nein-Wert.',
'attr_malformed_date' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist kein gültiges Datum.',
'attr_malformed_email' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist keine gültige E-Mail.',
'attr_malformed_float' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist keine Dezimalzahl.',
'attr_malformed_int' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist kein ganzzahliger Wert.',
'attr_malformed_url' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist keine gültige URL.',
'attr_max_values' => 'Die maximale Anzahl der erlaubten Werte für das Attribut [attrname] ist überschritten.',
'attr_min_values' => 'Die minimal Anzahl von Werte für das Attribut [attrname] ist nicht erreicht.',
'attr_not_in_valueset' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist nicht in der Werteauswahl.',
'attr_no_regex_match' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' passt nicht zum regulären Ausdruck \'[regex]\'',
'attr_validation_error' => 'Der Attributwert \'[value]\' des Attributs \'[attrname]\' ist ungültig.',
'at_least_n_users_of_group' => 'Mindestens [number_of_users] Benutzer der Gruppe [group]',
'august' => 'August',
'authentication' => 'Authentifizierung',
'authentication_failed' => 'Anmeldung fehlgeschlagen',
'author' => 'Autor',
'automatic_status_update' => 'Automatischer Statuswechsel',
'back' => 'Zurück',
'backup_list' => 'Liste vorhandener Backups',
'backup_log_management' => 'Backup/Logging',
'backup_remove' => 'Backup löschen',
'backup_tools' => 'Backup tools',
'between' => 'zwischen',
'bg_BG' => 'Bulgarisch',
'browse' => 'Durchsuchen',
'calendar' => 'Kalender',
'calendar_week' => 'Kalenderwoche',
'cancel' => 'Abbrechen',
'cancel_checkout' => 'Auschecken abbrechen',
'cancel_checkout_warning' => 'Das Auschecken kann beendet werden, auch wenn bereits Änderung am ausgecheckten Dokument vorgenommen worden sind. In dem Fall wird die Datei gelöscht und die Änderungen gehen verloren.',
'cannot_assign_invalid_state' => 'Die Zuweisung eines neuen Prüfers zu einem Dokument, welches noch nachbearbeitet oder überprüft wird ist nicht möglich',
'cannot_change_final_states' => 'Warnung: Der Dokumentstatus für Dokumente, die zurückgewiesen worden sind oder als abgelaufen bzw. veraltert markiert wurden, kann nicht geändert werden.',
'cannot_delete_user' => 'Benutzer kann nicht gelöscht werden',
'cannot_delete_yourself' => 'Sie können Ihr eigenes Login nicht löschen',
'cannot_move_root' => 'Fehler: Verschieben des Hauptordners nicht möglich',
'cannot_retrieve_approval_snapshot' => 'Für diese Dokumentenversion konnte der aktuelle Freigabestatus nicht ermittelt werden.',
'cannot_retrieve_review_snapshot' => 'Für diese Dokumentenversion konnte der aktuelle Prüfstatus nicht ermittelt werden.',
'cannot_revapp_expired_docs' => 'Das Dokument kann nicht mehr geprüft oder freigegeben werden, weil es bereits abgelaufen ist.',
'cannot_rm_root' => 'Fehler: Löschen des Hauptordners nicht möglich',
'cannot_transfer_your_objects' => 'Sie können Ihre eigenen Objekte nicht transferieren.',
'categories' => 'Kategorien',
'categories_loading' => 'Bitte warten, bis die Liste der Kategorien geladen ist …',
'category' => 'Kategorie',
'category_exists' => 'Kategorie existiert bereits.',
'category_filter' => 'Kategorien',
'category_info' => 'Information',
'category_in_use' => 'Diese Kategorie wird zur Zeit von Dokumenten verwendet.',
'category_noname' => 'Kein Kategoriename eingetragen.',
'ca_ES' => 'Katalanisch',
'changelog_loading' => 'Bitte warten, bis die Liste der Änderungen geladen ist …',
'change_assignments' => 'Setze Prüfer/Freigeber',
'change_password' => 'Passwort ändern',
'change_password_message' => 'Ihr Passwort wurde geändert.',
'change_recipients' => 'Setze Empfänger',
'change_revisors' => 'Setze Wiederholungsprüfer',
'change_status' => 'Status ändern',
'charts' => 'Diagramme',
'chart_docsaccumulated_title' => 'Anzahl Dokumente',
'chart_docspercategory_title' => 'Dokumente pro Kategorie',
'chart_docspermimetype_title' => 'Dokumente pro Mime-Type',
'chart_docspermonth_title' => 'Neue Dokumente pro Monat',
'chart_docsperstatus_title' => 'Dokumente pro Status',
'chart_docsperuser_title' => 'Dokumente pro Benutzer',
'chart_foldersperuser_title' => 'Ordner pro Benutzer',
'chart_selection' => 'Diagrammauswahl',
'chart_sizeperuser_title' => 'Speicherplatz pro Benutzer',
'checkedout_file_has_different_version' => 'Die ausgecheckte Version ist nicht identisch mit der aktuellen Version. Das Einchecken wird das Dokument nicht aktualisieren.',
'checkedout_file_has_disappeared' => 'Die Datei des ausgecheckten Dokuments ist nicht mehr vorhanden. Ein Einchecken ist nicht möglich.',
'checkedout_file_is_unchanged' => 'Die Datei des ausgecheckten Dokuments ist noch unverändert. Das Einchecken ist daher nicht möglich. Wenn Sie keine weiteren Änderungen am Dokument vornehmen möchten, dann setzen Sie den CheckOut-Status zurück.',
'checkin_document' => 'Einchecken',
'checkoutpath_does_not_exist' => 'Verzeichnis für das Auschecken von Dokumenten exisitiert nicht',
'checkout_cancel_confirm' => 'Beenden des Checkouts bestätigen',
'checkout_document' => 'Auschecken',
'checkout_is_disabled' => 'Auschecken von Dokumenten ist in der Konfiguration ausgeschaltet.',
'choose_attrdef' => 'Attributdefinition wählen',
'choose_attrdefgroup' => 'Attributgruppe wählen',
'choose_category' => 'Kategorie wählen',
'choose_group' => 'Gruppe wählen',
'choose_role' => 'Rolle wählen',
'choose_target_category' => 'Kategorie wählen',
'choose_target_document' => 'Dokument wählen',
'choose_target_file' => 'Datei wählen',
'choose_target_folder' => 'Ordner wählen',
'choose_user' => 'Benutzer wählen',
'choose_workflow' => 'Workflow wählen',
'choose_workflow_action' => 'Workflow-Aktion wählen',
'choose_workflow_state' => 'Workflow-Status wählen',
'class_finfo_missing' => 'Die Klasse finfo wird zur Ermittlung des MimeTypes beim Hochladen neuer Dateien benötigt.',
'class_name' => 'Klassenname',
'clear_cache' => 'Cache löschen',
'clear_clipboard' => 'Zwischenablage leeren',
'clear_password' => 'Passwort löschen',
'clipboard' => 'Zwischenablage',
'close' => 'Schließen',
'color' => 'Farbe',
'command' => 'Kommando',
'comment' => 'Kommentar',
'comment_changed_email' => '',
'comment_for_current_version' => 'Kommentar zur aktuellen Version',
'configure_extension' => 'Erweiterung konfigurieren',
'confirm_clear_cache' => 'Wollen Sie wirklich den Cache löschen? Dies entfernt alle vorberechneten Vorschaubilder.',
'confirm_create_fulltext_index' => 'Ja, Ich möchte den Volltext-Index neu erzeugen!.',
'confirm_move_document' => 'Dokument wirklich verschieben?',
'confirm_move_folder' => 'Ordner wirklich verschieben?',
'confirm_pwd' => 'Passwort-Bestätigung',
'confirm_rm_attr_value' => 'Möchten Sie wirklich den Attributwert löschen?',
'confirm_rm_backup' => 'Möchten Sie wirklich das Backup "[arkname]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_document' => 'Wollen Sie das Dokument \'[documentname]\' wirklich löschen?<br>Achtung: Dieser Vorgang kann nicht rückgängig gemacht werden.',
'confirm_rm_dump' => 'Möchten Sie wirklich den DB dump "[dumpname]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_event' => 'Möchten Sie wirklich das Ereignis "[name]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_file' => 'Möchten Sie wirklich die Datei "[name]" des Dokuments "[documentname]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_folder' => 'Wollen Sie den Ordner \'[foldername]\' mitsamt seines Inhalts wirklich löschen?<br>Achtung: Dieser Vorgang kann nicht rückgängig gemacht werden.',
'confirm_rm_folder_files' => 'Möchten Sie wirklich alle Dateien und Unterordner des Ordner "[foldername]" löschen?<br>Vorsicht: Diese Operation kann nicht rückgängig gemacht werden.',
'confirm_rm_group' => 'Möchten Sie wirklich die Gruppe "[groupname]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_log' => 'Möchten Sie wirklich die Log-Datei "[logname]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_task' => 'Bitte bestätigen Sie die Löschung dieser Task.',
'confirm_rm_transmittal' => 'Bitte bestätigen Sie das Löschen der Dokumentenliste.',
'confirm_rm_transmittalitem' => 'Löschen bestätigen',
'confirm_rm_user' => 'Möchten Sie wirklich den Benutzer "[username]" löschen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_rm_user_from_processes' => 'Möchten Sie wirklich den Benutzer "[username]" aus allen Prozessen löschen?<br />Beachten Sie, dass dies möglicherweise in der Freigabe von Dokumenten resultiert, wenn der Benutzer der einzige oder letzte Prüfer ist.',
'confirm_rm_version' => 'Wollen Sie die Version [version] des Dokumentes "[documentname]" wirklich löschen?<br>Achtung: Dieser Vorgang kann nicht rückgängig gemacht werden.',
'confirm_transfer_link_document' => 'Möchten Sie das Dokument verlinken oder dessen Inhalt auf das Zieldokument als neue Version übertragen. Der Inhalt kann nur übertragen werden, wenn das Ursprungsdokument genau eine Version hat. Das Ursprungsdokument wird danach gelöscht.',
'confirm_transfer_objects' => 'Möchten Sie wirklich die Dokumente, Ordner, etc. des Benutzer "[username]" übertragen?<br />Beachten Sie, dass diese Operation nicht rückgängig gemacht werden kann.',
'confirm_update_transmittalitem' => 'Aktualisierung bestätigen',
'content' => 'Inhalt',
'continue' => 'fortführen',
'converter_new_cmd' => 'Kommando',
'converter_new_mimetype' => 'Neuer Mime-Type',
'copied_to_checkout_as' => 'Datei am [date] von [username] in den Checkout-Space als \'[filename]\' kopiert.',
'create_download_link' => '',
'create_fulltext_index' => 'Erzeuge Volltext-Index',
'create_fulltext_index_warning' => 'Sie möchten den Volltext-Index neu erzeugen. Dies kann beträchtlich Zeit in Anspruch nehmen und Gesamtleistung Ihres System beeinträchtigen. Bestätigen Sie bitte diese Operation.',
'creation_date' => 'Erstellt am',
'cs_CZ' => 'Tschechisch',
'current_password' => 'Aktuelles Passwort',
'current_quota' => 'Der zur Zeit systemweit eingestellte Wert ist [quota].',
'current_state' => 'Aktueller Status',
'current_version' => 'Aktuelle Version',
'daily' => 'täglich',
'databasesearch' => 'Datenbanksuche',
'database_schema_version' => 'Version des Datenbankschemas',
'data_loading' => 'Bitte warten, bis die Daten geladen sind …',
'date' => 'Datum',
'days' => 'Tage',
'debug' => 'Debug',
'december' => 'Dezember',
'default_access' => 'Standardberechtigung',
'default_keywords' => 'Verfügbare Stichworte',
'definitions' => 'Definitionen',
'delete' => 'Löschen',
'details' => 'Details',
'details_version' => 'Details für Version: [version]',
'de_DE' => 'Deutsch',
'disable_extension' => 'Erweiterung deaktivieren',
'disclaimer' => 'Dies ist ein geschützter Bereich. Nur authorisiertes Personal hat Zugriff. Jegliche Verstöße werden nach geltendem Recht (Englisch und International) verfolgt.',
'discspace' => 'Plattenplatz',
'docs_in_reception_no_access' => 'Dokumente mit Empfangsbestätigung ohne Zugriff des Empfängers',
'docs_in_revision_no_access' => 'Dokumente in Revision ohne Zugriff des Prüfers',
'document' => 'Dokument',
'documentcontent' => 'Dokumentenversion',
'documents' => 'Dokumente',
'documents_checked_out_by_you' => 'Von mir ausgecheckte Dokumente',
'documents_expired' => 'Abgelaufene Dokumente',
'documents_in_process' => 'Dokumente in Bearbeitung',
'documents_locked' => 'Gesperrte Dokumente',
'documents_locked_by_you' => 'Von mir gesperrte Dokumente',
'documents_only' => 'Nur Dokumente',
'documents_rejected' => 'Abgelehnt',
'documents_to_approve' => 'Freigabe erforderlich',
'documents_to_correct' => 'Korrektur erforderlich',
'documents_to_process' => 'Dokumente, die bearbeitet werden müssen',
'documents_to_receipt' => 'Empfangsbestätigung erforderlich',
'documents_to_review' => 'Prüfung erforderlich',
'documents_to_revise' => 'Erneute Prüfung erforderlich',
'documents_to_trigger_workflow' => 'Dokumente im Workflow',
'documents_user_draft' => 'Entwürfe',
'documents_user_expiration' => 'Abgelaufene Dokumente',
'documents_user_needs_correction' => 'Dokumente, die korrigiert werden müssen',
'documents_user_no_reception' => 'Dokumente ohne Empfangsbestätigung',
'documents_user_obsolete' => 'Veraltete Dokumente',
'documents_user_reception' => 'Dokumente mit Empfangsbestätigung',
'documents_user_rejected' => 'Abgelehnte Dokumente',
'documents_user_requiring_attention' => 'Diese Dokumente sollte ich mal nachsehen',
'documents_with_notification' => 'Dokumente unter Beobachtung',
'document_already_checkedout' => 'Dieses Dokument ist bereits ausgecheckt',
'document_already_locked' => 'Dieses Dokument ist bereits gesperrt',
'document_attribute_changed_email_body' => 'Attribut geändert

Dokument: [name]
Attribut: [attribute_name]
Alter Wert: [attribute_old_value]
Neuer Wert: [attribute_new_value]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'document_attribute_changed_email_body_html' => '<p>Attribut geändert</p>

<p>Dokument: [name]<br />
Attribut: [attribute_name]<br />
Alter Wert: [attribute_old_value]<br />
Neuer Wert: [attribute_new_value]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_attribute_changed_email_subject' => '[sitename]: [name] - Attribut geändert',
'document_comment_changed_email' => 'Kommentar geändert',
'document_comment_changed_email_body' => 'Kommentar geändert

Dokument: [name]
Alter Kommentar: [old_comment]
Neuer Kommentar: [new_comment]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'document_comment_changed_email_body_html' => '<p>Kommentar geändert</p>

<p>Dokument: [name]<br />
Alter Kommentar: [old_comment]<br />
Neuer Kommentar: [new_comment]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_comment_changed_email_subject' => '[sitename]: [name] - Kommentar geändert',
'document_content_missing' => 'Datei der Version nicht vorhanden',
'document_count' => 'Anzahl der Dokumente',
'document_deleted' => 'Dokument gelöscht',
'document_deleted_email' => 'Dokument gelöscht',
'document_deleted_email_body' => 'Dokument gelöscht

Dokument: [name]
Elternordner: [folder_path]
Benutzer: [username]',
'document_deleted_email_body_html' => '<p>Dokument gelöscht</p>

<p>Dokument: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]</p>',
'document_deleted_email_subject' => '[sitename]: [name] - Dokument gelöscht',
'document_duplicate_name' => 'Doppelter Dokumentenname',
'document_files' => 'Dokumentenanhänge',
'document_has_no_workflow' => 'Dokument hat keinen Workflow',
'document_infos' => 'Informationen',
'document_is_checked_out' => '',
'document_is_checked_out_remove' => 'Das Dokument ist zur Zeit ausgecheckt. Wenn Sie das Dokument löschen kann die ausgecheckte Version nicht mehr hochgeladen werden und verbleibt im Auscheck-Bereich.',
'document_is_checked_out_update' => 'Das Dokument ist zur Zeit ausgecheckt. Wenn Sie eine neue Version hochladen, werden Sie die ausgecheckte Version nicht mehr einchecken können.',
'document_is_not_locked' => 'Dieses Dokument ist nicht gesperrt',
'document_links' => 'Verknüpfungen zu Dokumenten',
'document_link_by' => 'Verknüpfung erstellt von',
'document_link_public' => 'Für alle sichtbar',
'document_moved_email' => 'Dokument verschoben',
'document_moved_email_body' => 'Dokument verschoben

Dokument: [name]
Alter Ordner: [old_folder_path]
Neuer Ordner: [new_folder_path]
Benutzer: [username]
URL: [url]',
'document_moved_email_body_html' => '<p>Dokument verschoben</p>

<p>Dokument: [name]<br />
Alter Ordner: [old_folder_path]<br />
Neuer Ordner: [new_folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_moved_email_subject' => '[sitename]: [name] - Dokument verschoben',
'document_not_checkedout' => 'Dokument ist nicht ausgecheckt.',
'document_renamed_email' => 'Dokument umbenannt',
'document_renamed_email_body' => 'Dokument umbenannt

Dokument: [name]
Elternordner: [folder_path]
Old name: [old_name]
Benutzer: [username]
URL: [url]',
'document_renamed_email_body_html' => '<p>Dokument umbenannt</p>

<p>Dokument: [name]<br />
Elternordner: [folder_path]<br />
Old name: [old_name]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_renamed_email_subject' => '[sitename]: [name] - Dokument umbenannt',
'document_status_changed_email' => 'Dokumentenstatus geändert',
'document_status_changed_email_body' => 'Dokumentenstatus geändert

Dokument: [name]
Status: [status]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'document_status_changed_email_body_html' => '<p>Dokumentenstatus geändert</p>

<p>Dokument: [name]<br />
Status: [status]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_status_changed_email_subject' => '[sitename]: [name] - Dokumentenstatus geändert',
'document_title' => 'Dokument \'[documentname]\'',
'document_transfered_email_body' => 'Dokument an anderen Benutzer übertragen

Dokument: [name]
Neuer Besitzer: [newuser]
Alter Besitzer: [olduser]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'document_transfered_email_body_html' => '<p>Dokument an anderen Benutzer übertragen</p>

<p>Dokument: [name]<br />
Neuer Besitzer: [newuser]<br />
Alter Besitzer: [olduser]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'document_transfered_email_subject' => '[sitename]: [name] - Dokument übertragen',
'document_updated_email' => 'Dokument aktualisiert',
'document_updated_email_body' => 'Dokument aktualisiert

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
Kommentar: [comment]
Kommentar der Version: [version_comment]
URL: [url]',
'document_updated_email_body_html' => '<p>Dokument aktualisiert</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
Kommentar: [comment]<br />
Kommentar der Version: [version_comment]<br />
URL: [url]</p>',
'document_updated_email_subject' => '[sitename]: [name] - Dokument aktualisiert',
'document_versions' => 'Dokumentenversionen',
'does_not_expire' => 'Kein Ablaufdatum',
'does_not_inherit_access_msg' => 'Berechtigungen wieder erben',
'download' => 'Download',
'download_extension' => 'Erweiterung als zip-Datei herunterladen',
'download_header_approval_comment' => 'Freigabekommentar',
'download_header_approval_date' => 'Freigabedatum',
'download_header_approval_state' => 'Freigabestatus',
'download_header_approver' => 'Freigeber',
'download_header_document_name' => 'Dokumentenname',
'download_header_document_no' => 'Dokumenten-Nr.',
'download_header_filename' => 'Dateiname',
'download_header_internal_version' => 'Int. Version',
'download_header_reviewer' => 'Prüfer',
'download_header_review_comment' => 'Prüfkommentar',
'download_header_review_date' => 'Prüfdatum',
'download_header_review_state' => 'Prüfstatus',
'download_header_state' => 'Status',
'download_links' => 'Download Links',
'download_link_email_body' => '',
'download_link_email_subject' => '',
'do_no_transfer_to_user' => 'Prozesse nicht auf anderen Benutzer übertragen',
'do_object_repair' => 'Repariere alle Ordner und Dokumente.',
'do_object_setchecksum' => 'Setze Check-Summe',
'do_object_setfilesize' => 'Setze Dateigröße',
'do_object_setfiletype' => 'Setze Dateityp',
'do_object_unlink' => 'Lösche Dokumentenversion',
'draft' => 'Entwurf',
'draft_pending_approval' => 'Freigabe erforderlich',
'draft_pending_review' => 'Prüfung erforderlich',
'drag_icon_here' => 'Ordners oder Dokument hier hin ziehen!',
'dropfolderdir_missing' => 'Ihr persönlicher Ablageordner auf dem Server existiert nicht! Kontaktieren Sie den Administrator, um in anlegen zu lassen.',
'dropfolder_file' => 'Datei aus Ablageordner',
'dropfolder_folder' => 'Ordner aus Ablageordner',
'dropfolder_metadata' => 'Metadaten der zu importierenen Dateien',
'dropupload' => 'Direkt Hochladen',
'drop_files_here' => 'Dateien hier hin ziehen!',
'drop_files_here_or_click' => 'Dateien hier hin ziehen oder Klicken!',
'dump_creation' => 'DB dump erzeugen',
'dump_creation_warning' => 'Mit dieser Operation können Sie einen Dump der Datenbank erzeugen. Nach der Erstellung wird der Dump im Datenordner Ihres Servers gespeichert.',
'dump_list' => 'Vorhandene DB dumps',
'dump_remove' => 'DB dump löschen',
'duplicates' => 'Duplikate',
'duplicate_content' => 'Doppelte Dateien',
'edit' => 'Bearbeiten',
'edit_attributes' => 'Attribute bearbeiten',
'edit_comment' => 'Kommentar bearbeiten',
'edit_default_keywords' => 'Stichworte bearbeiten',
'edit_document_access' => 'Zugriffsrechte',
'edit_document_notify' => 'Beobachtung von Dokumenten',
'edit_document_props' => 'Bearbeiten',
'edit_event' => 'Ereignis editieren',
'edit_existing_access' => 'Bestehende Berechtigungen bearbeiten',
'edit_existing_attribute_groups' => 'Attributgruppen bearbeiten',
'edit_existing_notify' => 'Beobachter bearbeiten',
'edit_folder_access' => 'Zugriffsrechte',
'edit_folder_attrdefgrp' => 'Attributgruppen bearbeiten',
'edit_folder_notify' => 'Beobachtung von Ordnern',
'edit_folder_props' => 'Bearbeiten',
'edit_group' => 'Gruppe bearbeiten',
'edit_online' => 'Online editieren',
'edit_online_not_allowed' => 'Sie dürfen diese Fassung nicht verändern, weil Sie nicht von Ihnen angelegt wurde. Laden Sie stattdessen eine neue Version hoch.',
'edit_online_warning' => 'Mit dem Speichern wird die aktuellen Version des Dokuments überschrieben. Es wird keine neue Version angelegt.',
'edit_task' => 'Task editieren',
'edit_transmittal_props' => 'Attribute der Dokumentenliste bearbeiten',
'edit_user' => 'Benutzer bearbeiten',
'edit_user_details' => 'Benutzerdetails bearbeiten',
'edit_version' => 'Version editieren',
'el_GR' => 'Griechisch',
'email' => 'Email',
'email_error_title' => 'Keine E-Mail-Adresse eingegeben',
'email_footer' => 'Sie können zu jeder Zeit Ihre E-Mail-Adresse über \'Mein Profil\' ändern.',
'email_footer_html' => '<p>Sie können zu jeder Zeit Ihre E-Mail-Adresse über \'Mein Profil\' ändern.</p>',
'email_header' => 'Dies ist eine automatische Nachricht des DMS-Servers.',
'email_header_html' => '<p>Dies ist eine automatische Nachricht des DMS-Servers.</p>',
'email_not_given' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
'empty_attribute_group_list' => 'Keine Attributgruppen',
'empty_folder_list' => 'Keine Dokumente oder Ordner',
'empty_list' => 'Keine Einträge',
'empty_notify_list' => 'Keine Beobachter',
'enable_extension' => 'Erweiterunge aktivieren',
'en_GB' => 'Englisch (GB)',
'equal_transition_states' => 'Start- und Endstatus ѕind gleich',
'error' => 'Fehler',
'error_add_aro' => 'Fehler beim Hinzufügen des Zugriffsobjekts',
'error_add_permission' => 'Fehler beim Hinzufügen der Berechtigung',
'error_cleared_cache' => 'Fehler beim Löschen des Cache',
'error_document_indexed' => 'Fehler beim Indizieren des Dokuments',
'error_edit_task' => 'Fehler beim Speichern der Task',
'error_extension_getlist' => 'Fehler beim Holen der Liste der Erweiterungen aus dem Repositorium',
'error_importfs' => 'Fehler beim Importieren aus dem Dateisystem',
'error_no_document_selected' => 'Kein Dokument ausgewählt',
'error_no_folder_selected' => 'Kein Ordner ausgewählt',
'error_occured' => 'Ein Fehler ist aufgetreten. Bitte Administrator benachrichtigen.',
'error_remove_document' => 'Fehler beim Löschen des Dokuments',
'error_remove_folder' => 'Fehler beim Löschen des Ordners',
'error_remove_permission' => 'Fehler beim Entfernen der Berechtigung',
'error_rm_workflow' => 'Fehler beim Löschen des Workflows',
'error_rm_workflow_action' => 'Fehler beim Löschen der Workflow-Aktion',
'error_rm_workflow_state' => 'Fehler beim Löschen des Workflows-Status',
'error_toogle_permission' => 'Fehler beim Ändern der Berechtigung',
'error_transfer_document' => 'Fehler beim Übertragen des Dokuments',
'error_trigger_workflow' => 'Fehler beim Auslösen der Transitions des Workflows',
'error_update_document' => 'Fehler beim Aktualisieren des Dokuments',
'error_uploading_reviewer_only' => 'Fehler beim Anlegen des Dokuments. Das Dokument besitzt einen Prufer, aber keinen Freigeber.',
'es_ES' => 'Spanisch',
'event_details' => 'Ereignisdetails',
'exclude_items' => 'Einträge auslassen',
'expired' => 'abgelaufen',
'expired_at_date' => 'Abgelaufen am [datetime]',
'expired_docs_mail_subject' => 'Abgelaufende Dokumente',
'expired_documents' => 'Abgelaufene Dokumente',
'expires' => 'Ablaufdatum',
'expire_by_date' => 'Ablauf nach Datum',
'expire_in_1d' => 'Ablauf in 1 Tag',
'expire_in_1h' => 'Ablauf in 1 Std.',
'expire_in_1m' => 'Ablauf in 1 Monat',
'expire_in_1w' => 'Ablauf in 1 Woche',
'expire_in_1y' => 'Ablauf in 1 Jahr',
'expire_in_2h' => 'Ablauf in 2 Std.',
'expire_in_2y' => 'Ablauf in 2 Jahren',
'expire_in_3y' => 'Ablauf in 3 Jahren',
'expire_today' => 'Ablauf heute',
'expire_tomorrow' => 'Ablauf morgen',
'expiry_changed_email' => 'Ablaufdatum geändert',
'expiry_changed_email_body' => 'Ablaufdatum geändert

Dokument: [name]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'expiry_changed_email_body_html' => '<p>Ablaufdatum geändert</p>

<p>Dokument: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'expiry_changed_email_subject' => '[sitename]: [name] - Ablaufdatum geändert',
'export' => 'Export',
'export_user_list_csv' => 'Exportiere Benutzer als CSV-Datei',
'extension_archive' => 'Erweiterung',
'extension_changelog' => 'Versionshistorie',
'extension_is_off_now' => 'Erweiterung ist ausgeschaltet',
'extension_is_on_now' => 'Erweiterung ist eingeschaltet',
'extension_loading' => 'Lade Erweiterungen ...',
'extension_manager' => 'Erweiterungen verwalten',
'extension_mgr_error_upload' => 'Beim Hochladen der Extension ist ein Fehler aufgetreten.',
'extension_mgr_installed' => 'Installiert',
'extension_mgr_no_upload' => 'Der Upload neuer Erweiterungen ist nicht möglich, weil das Verzeichnis für Erweiterungen nicht beschreibbar ist.',
'extension_mgr_no_zipfile' => 'Die hochgeladene Erweiterung ist keine Zip-Datei',
'extension_mgr_repository' => 'Verfügbar',
'extension_mgr_upload_disabled' => 'Der Upload neuer Erweiterungen ist nicht möglich, weil dies in den Einstellungen ausgeschaltet ist.',
'extension_missing_name' => 'Kein Erweiterungsname übergeben',
'extension_toggle_error' => 'Konnte Erweiterung nicht aus/einschalten',
'extension_version_list' => 'Versionen',
'february' => 'Februar',
'file' => 'Datei',
'files' => 'Dateien',
'files_deletion' => 'Dateien löschen',
'files_deletion_warning' => 'Durch diese Operation können Sie Dokumente des DMS löschen. Die Versions-Information bleibt erhalten.',
'files_loading' => 'Bitte warten, bis die Dateiliste geladen ist …',
'filetype' => 'Dateityp',
'file_size' => 'Dateigröße',
'filter_for_documents' => 'Zusätzliche Filter für Dokumente',
'filter_for_folders' => 'Zusätzliche Filter für Ordner',
'folder' => 'Ordner',
'folders' => 'Verzeichnisse',
'folders_and_documents_statistic' => 'Ordner- und Dokumentenübersicht',
'folders_with_notification' => 'Ordner unter Beobachtung',
'folder_attribute_changed_email_body' => 'Attribut geändert

Ordner: [name]
Attribut: [attribute_name]
Alter Wert: [attribute_old_value]
Neuer Wert: [attribute_new_value]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'folder_attribute_changed_email_body_html' => '<p>Attribut geändert</p>

<p>Ordner: [name]<br />
Attribut: [attribute_name]<br />
Alter Wert: [attribute_old_value]<br />
Neuer Wert: [attribute_new_value]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'folder_attribute_changed_email_subject' => '[sitename]: [name] - Attribut geändert',
'folder_comment_changed_email' => 'Kommentar geändert',
'folder_comment_changed_email_body' => 'Kommentar geändert

Ordner: [name]
Alter Kommentar: [old_comment]
Neuer Kommentar: [new_comment]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'folder_comment_changed_email_body_html' => '<p>Kommentar geändert</p>

<p>Ordner: [name]<br />
Alter Kommentar: [old_comment]<br />
Neuer Kommentar: [new_comment]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'folder_comment_changed_email_subject' => '[sitename]: [name] - Kommentar geändert',
'folder_contents' => 'Ordner enthält',
'folder_deleted_email' => 'Ordner gelöscht',
'folder_deleted_email_body' => 'Ordner gelöscht
Ordner: [name]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'folder_deleted_email_body_html' => '<p>Ordner gelöscht</p>

<p>Ordner: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'folder_deleted_email_subject' => '[sitename]: [name] - Ordner gelöscht',
'folder_infos' => 'Informationen',
'folder_moved_email' => 'Ordner verschoben',
'folder_moved_email_body' => 'Ordner verschoben

Ordner: [name]
Old folder: [old_folder_path]
Neuer Ordner: [new_folder_path]
Benutzer: [username]
URL: [url]',
'folder_moved_email_body_html' => '<p>Ordner verschoben</p>

<p>Ordner: [name]<br />
Old folder: [old_folder_path]<br />
Neuer Ordner: [new_folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'folder_moved_email_subject' => '[sitename]: [name] - Ordner verschoben',
'folder_renamed_email' => 'Ordner umbenannt',
'folder_renamed_email_body' => 'Ordner umbenannt

Ordner: [name]
Elternordner: [folder_path]
Old name: [old_name]
Benutzer: [username]
URL: [url]',
'folder_renamed_email_body_html' => '<p>Ordner umbenannt</p>

<p>Ordner: [name]<br />
Elternordner: [folder_path]<br />
Old name: [old_name]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'folder_renamed_email_subject' => '[sitename]: [name] - Ordner umbenannt',
'folder_title' => 'SeedDMS - Ordner: [foldername]',
'foot_note' => '',
'force_update' => 'Aktualisieren',
'friday' => 'Freitag',
'friday_abbr' => 'Fr',
'from' => 'von',
'fr_FR' => 'Französisch',
'fullsearch' => 'Volltext',
'fullsearch_hint' => 'Volltext-Index benutzen',
'fulltextsearch_disabled' => 'Volltext-Index ist ausgeschaltet',
'fulltext_converters' => 'Index Dokumentenumwandlung',
'fulltext_info' => 'Volltext-Index Info',
'func_proc_open_missing' => 'proc_open wird benötigt, um Dokumente im Volltext zu indizieren. Ohne diese Funktion werden lediglich die Metadaten indiziert.',
'global_attributedefinitiongroups' => 'Attributgruppen',
'global_attributedefinitions' => 'Attribute',
'global_default_keywords' => 'Globale Stichwortlisten',
'global_document_categories' => 'Kategorien',
'global_workflows' => 'Workflows',
'global_workflow_actions' => 'Workflow-Aktionen',
'global_workflow_states' => 'Workflow-Status',
'group' => 'Gruppe',
'groups' => 'Gruppen',
'group_approval_summary' => 'Übersicht Gruppenfreigabe',
'group_exists' => 'Gruppe existiert bereits',
'group_info' => 'Gruppeninformation',
'group_management' => 'Gruppenverwaltung',
'group_members' => 'Gruppenmitglieder',
'group_receipt_summary' => 'Übersicht Gruppenbestätigungen',
'group_review_removed' => 'Statuswechsel, weil Prufung der Gruppe [name] entfernt wurde.',
'group_review_summary' => 'Übersicht Gruppenprüfungen',
'group_revision_summary' => 'Übersicht Gruppenwiederholungsprüfungen',
'guest_login' => 'Als Gast anmelden',
'guest_login_disabled' => 'Anmeldung als Gast ist gesperrt.',
'hash' => 'Hash-Wert',
'help' => 'Hilfe',
'home_folder' => 'Heimatordner',
'hook_name' => 'Name des Aufrufs',
'hourly' => 'stündlich',
'hours' => 'Stunden',
'hr_HR' => 'Kroatisch',
'human_readable' => 'Menschenlesbares Archiv',
'hu_HU' => 'Ungarisch',
'id' => 'ID',
'identical_version' => 'Neue Version ist identisch zu aktueller Version.',
'id_ID' => 'Indonesisch',
'import' => 'Importiere',
'importfs' => 'Importiere aus Dateisystem',
'import_extension' => 'Erweiterung importieren',
'import_fs' => 'Aus Dateisystem importieren',
'import_fs_warning' => 'Der Import kann nur für Ordner im Ablageordner erfolgen. Alle Ordner und Dateien werden rekursiv importiert. Dateien werden sofort freigegeben.',
'import_users' => 'Importiere Benutzer',
'import_users_addnew' => 'Neue Benutzer anlegen',
'import_users_update' => 'Aktualisiere bestehende Benutzer',
'include_content' => 'Inhalte mit exportieren',
'include_documents' => 'Dokumente miteinbeziehen',
'include_subdirectories' => 'Unterverzeichnisse miteinbeziehen',
'indexing_tasks_in_queue' => 'Indiziervorgänge in der Warteschleife',
'index_converters' => '',
'index_document_added' => 'Dokument hinzugefügt',
'index_document_unchanged' => 'Dokument unverändert',
'index_document_updated' => 'Dokument aktualisiert',
'index_done' => 'Fertig',
'index_error' => 'Fehler',
'index_folder' => 'Indiziere Ordner',
'index_folder_added' => 'Ordner hinzugefügt',
'index_folder_unchanged' => 'Ordner unverändert',
'index_folder_updated' => 'Ordner aktualisiert',
'index_no_content' => 'Inhalt nicht indiziert',
'index_pending' => 'Vorgemerkt',
'index_waiting' => 'Warte',
'individuals' => 'Einzelpersonen',
'individuals_in_groups' => 'Mitglieder einer Gruppe',
'ind_review_removed' => 'Statuswechsel, weil Prufung des Benutzers [name] entfernt wurde.',
'info_recipients_tab_not_released' => 'Die Bestätigung des Empfangs für diese Dokumentenversion ist nicht möglich, weil die Version nicht freigegeben ist.',
'info_rm_user_from_processes_user' => 'Nur die noch offenen Aufgaben können auf einen anderen Benutzer übertragen werden. Bei Aufgaben, die bereits bearbeitet wurden, wird der Benutzer aus der Bearbeitungshistorie gelöscht, als würde der Benutzer selbst gelöscht.',
'inherited' => 'geerbt',
'inherits_access_copy_msg' => 'Berechtigungen kopieren',
'inherits_access_empty_msg' => 'Leere Zugriffsliste',
'inherits_access_msg' => 'Zur Zeit werden die Rechte geerbt',
'installed_apache_extensions' => 'Installierte Apache-Erweiterungen',
'installed_php_extensions' => 'Installierte PHP-Erweiterungen',
'internal_error' => 'Interner Fehler',
'internal_error_exit' => 'Interner Fehler: Anfrage kann nicht ausgeführt werden.',
'invalid_access_mode' => 'Unzulässige Zugangsart',
'invalid_action' => 'Unzulässige Aktion',
'invalid_approval_status' => 'Unzulässiger Freigabestatus',
'invalid_create_date_end' => 'Unzulässiges Erstellungsenddatum.',
'invalid_create_date_start' => 'Unzulässiges Erstellungsstartdatum.',
'invalid_doc_id' => 'Unzulässige Dokumentenidentifikation',
'invalid_dropfolder_folder' => 'Ungültiger Ordner im Ablageordner',
'invalid_expiration_date_end' => 'Unzulässiges Ablaufenddatum.',
'invalid_expiration_date_start' => 'Unzulässiges Ablaufstartdatum.',
'invalid_file_id' => 'Ungültige Datei-ID',
'invalid_folder_id' => 'Unzulässige Ordneridentifikation',
'invalid_group_id' => 'Unzulässige Gruppenidentifikation',
'invalid_link_id' => 'Unzulässige Linkbezeichnung',
'invalid_request_token' => 'Ungültige Anfragekennung',
'invalid_review_status' => 'Unzulässiger Überprüfungssstatus',
'invalid_sequence' => 'Unzulässige Reihenfolge der Werte',
'invalid_status' => 'Unzulässiger Dokumentenstatus',
'invalid_target_doc_id' => 'Unzulässige Ziel-Dokument Identifikation',
'invalid_target_folder' => 'Unzulässige Ziel-Ordner Identifikation',
'invalid_user_id' => 'Unzulässige Benutzernummer',
'invalid_version' => 'Unzulässige Dokumenten-Version',
'in_folder' => 'In',
'in_revision' => 'Erneute Prüfung',
'in_workflow' => 'im Workflow',
'is_disabled' => 'Anmeldung sperren',
'is_hidden' => 'In der Benutzerliste verbergen',
'it_IT' => 'Italienisch',
'january' => 'Januar',
'js_form_error' => 'Das Formular beinhaltet noch # Fehler.',
'js_form_errors' => 'Das Formular beinhaltet noch # Fehler.',
'js_invalid_email' => 'Die E-Mail-Adresse ist ungültig',
'js_no_approval_group' => 'Wählen Sie bitte eine Freigabe-Gruppe aus',
'js_no_approval_status' => 'Wählen Sie bitte einen Freigabe-Status aus',
'js_no_comment' => 'Geben Sie einen Kommentar an',
'js_no_currentpwd' => 'Bitte das aktuelle Passwort eintragen',
'js_no_document' => 'Wählen Sie bitte ein Dokument aus',
'js_no_email' => 'Geben Sie eine Email-Adresse an',
'js_no_file' => 'Bitte wählen Sie eine Datei',
'js_no_folder' => 'Wählen Sie bitte einen Ordner aus',
'js_no_keywords' => 'Geben Sie einige Stichwörter an',
'js_no_login' => 'Geben Sie einen Benutzernamen ein',
'js_no_name' => 'Sie haben den Namen vergessen',
'js_no_override_status' => 'Bitte wählen Sie einen neuen Status aus',
'js_no_pwd' => 'Sie müssen ein Passwort eingeben',
'js_no_query' => 'Geben Sie einen Suchbegriff ein',
'js_no_review_group' => 'Bitte wählen Sie eine Prüfer-Gruppe',
'js_no_review_status' => 'Bitte wählen Sie einen Prüfungs-Status',
'js_pwd_not_conf' => 'Passwort und -Bestätigung stimmen nicht überein',
'js_select_user' => 'Bitte einen Benutzer auswählen',
'js_select_user_or_group' => 'Wählen Sie mindestens einen Benutzer oder eine Gruppe aus',
'js_unequal_passwords' => 'Die Passwörter sind nicht gleich',
'july' => 'Juli',
'june' => 'Juni',
'keep' => 'Beibehalten',
'keep_doc_status' => 'Dokumentenstatus beibehalten',
'keywords' => 'Stichworte',
'keywords_loading' => 'Bitte warten, bis die Stichwortliste geladen ist …',
'keyword_exists' => 'Stichwort besteht bereits',
'ko_KR' => 'Koreanisch',
'language' => 'Sprache',
'lastaccess' => 'Letzter Zugriff',
'last_update' => 'Letzte Aktualisierung',
'legend' => 'Legende',
'librarydoc' => 'Dokument aus Bibliothek',
'linked_documents' => 'verknüpfte Dokumente',
'linked_files' => 'Anhänge',
'linked_to_current_version' => 'Mit aktueller Version verknüpft',
'linked_to_document' => 'Mit dem Dokument verknüpft',
'linked_to_this_version' => 'Mit dieser Version verknüpft',
'link_alt_updatedocument' => 'Wenn Sie ein Dokument hochladen möchten, das größer als die maximale Dateigröße ist, dann benutzen Sie bitte die alternative <a href="%s">Upload-Seite</a>.',
'link_document' => 'Dokument verlinken',
'link_to_version' => 'An Version hängen',
'list_access_rights' => 'Alle Zugriffsrechte auflisten ...',
'list_contains_no_access_docs' => 'Die Liste enthält weitere Dokumente auf die Sie keinen Zugriff haben und deshalb nicht angezeigt werden.',
'list_hooks' => 'Liste interne Aufrufe',
'list_tasks' => 'Tasks auflisten',
'local_file' => 'Lokale Datei',
'locked_by' => 'Gesperrt von',
'lock_document' => 'Sperren',
'lock_message' => 'Dieses Dokument ist durch [username] gesperrt. Nur authorisierte Benutzer können diese Sperrung aufheben.',
'lock_status' => 'Status',
'logfile' => 'Log-Datei',
'logfile_loading' => 'Bitte warten, bis die Log-Datei geladen ist …',
'login' => 'Login',
'login_disabled_text' => 'Ihr Konto ist gesperrt. Der Grund sind möglicherweise zu viele gescheiterte Anmeldeversuche.',
'login_disabled_title' => 'Konto gesperrt',
'login_error_text' => 'Fehler bei der Anmeldung. Benutzernummer oder Passwort falsch.',
'login_error_title' => 'Fehler bei der Anmeldung',
'login_not_given' => 'Es wurde kein Benutzername eingegeben',
'login_ok' => 'Anmeldung erfolgreich',
'login_restrictions_apply' => 'Anmeldung wegen Beschränkungen fehlgeschlagen',
'logout' => 'Abmelden',
'log_management' => 'Management der Log-Dateien',
'lo_LA' => 'Laotisch',
'malformed_expiration_date' => 'Fehlerhaftes Ablaufdatum',
'manager' => 'Manager',
'manager_of_group' => 'Sie sind der Manager dieser Gruppe',
'mandatory_approvergroups' => 'Zwingende Gruppen von Freigebern',
'mandatory_approvergroup_no_access' => 'Zwingende Gruppe von Freigebern \'[group]\' hat unzureichende Zugriffsrechte.',
'mandatory_approvers' => 'Zwingende Freigeber',
'mandatory_approver_no_access' => 'Zwingender Freigeber \'[user]\' hat unzureichende Zugriffsrechte.',
'mandatory_reviewergroups' => 'Zwingende Gruppen von Prüfern',
'mandatory_reviewergroup_no_access' => 'Zwingende Gruppe von Prüfern \'[group]\' hat unzureichende Zugriffsrechte.',
'mandatory_reviewers' => 'Zwingende Prüfer',
'mandatory_reviewer_no_access' => 'Zwingender Prüfer \'[user]\' hat nicht ausreichende Zugriffsrechte.',
'march' => 'März',
'max_upload_size' => 'Maximale Dateigröße',
'may' => 'Mai',
'menu_dropfolder' => 'Ablageordner',
'menu_upload_from_dropfolder' => 'Diese Datei importieren',
'message' => 'Meldung',
'mimetype' => 'Mime-Type',
'minutes' => 'Minuten',
'misc' => 'Sonstiges',
'missing_checksum' => 'Fehlende Check-Summe',
'missing_file' => 'Datei fehlt',
'missing_filesize' => 'Fehlende Dateigröße',
'missing_func_class_note' => 'Anmerkung',
'missing_php_extensions' => 'Fehlende PHP-Erweiterungen',
'missing_php_functions_and_classes' => 'Fehlende PHP-Funktionen und Klassen',
'missing_reception' => 'Fehlende Empfangsbestätigung',
'missing_request_object' => 'Fehlendes Zugriffsobjekte',
'missing_transition_user_group' => 'Fehlende/r Benutzer/Gruppe für Transition',
'monday' => 'Montag',
'monday_abbr' => 'Mo',
'monthly' => 'monatlich',
'month_view' => 'Monatsansicht',
'more_objects_loading' => 'Weitere Objekte werden geladen ...',
'move' => 'Verschieben',
'move_clipboard' => 'Zwischenablage in Ordner verschieben',
'move_document' => 'Verschieben',
'move_folder' => 'Verschieben',
'my_account' => 'Mein Profil',
'my_documents' => 'Meine Dokumente',
'my_transmittals' => 'Meine Dokumentenlisten',
'name' => 'Name',
'nav_brand_admin_tools' => 'Administration',
'nav_brand_calendar' => 'Kalender',
'nav_brand_my_account' => 'Mein Profil',
'nav_brand_my_documents' => 'Meine Dokumente',
'nav_brand_view_document' => 'Dokument',
'nav_brand_view_folder' => 'Ordner',
'nb_NO' => 'Norwegisch',
'needs_correction' => 'Korrektur erforderlich',
'needs_workflow_action' => 'Dieses Dokument erfordert eine Aktion. Bitte schauen Sie auf den Workflow-Reiter.',
'network_drive' => 'Netzwerklaufwerk',
'never' => 'nie',
'new' => 'Neu',
'new_attrdef' => 'Neue Attributdefinition',
'new_default_keywords' => 'Neue Vorlage',
'new_default_keyword_category' => 'Neue Kategorie',
'new_document_category' => 'Neue Kategorie',
'new_document_email' => 'Neues Dokument',
'new_document_email_body' => 'Neues Dokument

Name: [name]
Ordner: [folder_path]
Kommentar: [comment]
Kommentar der Version: [version_comment]
URL: [url]',
'new_document_email_body_html' => '<p>Neues Dokument</p>

<p>Name: [name]<br />
Ordner: [folder_path]<br />
Kommentar: [comment]<br />
Kommentar der Version: [version_comment]<br />
URL: [url]</p>',
'new_document_email_subject' => '[sitename]: [folder_name] - Neues Dokument',
'new_file_email' => 'Neuer Anhang',
'new_file_email_body' => 'Neuer Anhang

Name: [name]
Dokument: [document]
Comment: [comment]
Benutzer: [username]
URL: [url]',
'new_file_email_body_html' => '<p>Neuer Anhang</p>

<p>Name: [name]<br />
Dokument: [document]<br />
Comment: [comment]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'new_file_email_subject' => '[sitename]: [document] - Neuer Anhang',
'new_folder' => 'Neuer Ordner',
'new_password' => 'Neues Passwort',
'new_subfolder_email' => 'Neuer Ordner',
'new_subfolder_email_body' => 'Neuer Ordner

Name: [name]
Elternordner: [folder_path]
Comment: [comment]
Benutzer: [username]
URL: [url]',
'new_subfolder_email_body_html' => '<p>Neuer Ordner</p>

<p>Name: [name]<br />
Elternordner: [folder_path]<br />
Comment: [comment]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'new_subfolder_email_subject' => '[sitename]: [folder_name] - Neuer Ordner',
'new_user_image' => 'Neues Bild',
'next_revision_abbr' => 'Nächste Wieder.-Prüf.',
'next_state' => 'Neuer Status',
'nl_NL' => 'Niederländisch',
'no' => 'Nein',
'notification' => 'Beobachter',
'notify_added_email' => 'Benachrichtigung per Mail wurde eingerichtet',
'notify_added_email_body' => 'Zur Liste der Beobachter hinzugefügt.

Name: [name]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'notify_added_email_body_html' => '<p>Zur Liste der Beobachter hinzugefügt.</p>
<p>Name: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'notify_added_email_subject' => '[sitename]: [name] - Added to notification list',
'notify_deleted_email' => 'Sie wurden von der Liste der Beobachter entfernt.',
'notify_deleted_email_body' => 'Aus Liste der Beobachter entfernt
Name: [name]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'notify_deleted_email_body_html' => '<p>Aus Liste der Beobachter entfernt</p>
<p>Name: [name]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'notify_deleted_email_subject' => '[sitename]: [name] - Removed from notification list',
'not_subscribed' => 'Nicht abonniert',
'november' => 'November',
'now' => 'sofort',
'no_action' => 'Keine Aktion erforderlich.',
'no_approval_needed' => 'Keine offenen Freigaben.',
'no_attached_files' => 'Keine angehängten Dokumente',
'no_attributes_defined' => 'Sie haben bisher keine eigenen Attribute erstellt.',
'no_attribute_definitions' => 'Es wurde bisher keine Attribute definiert',
'no_backup_dir' => 'Das Backup-Verzeichnis ist nicht gesetzt',
'no_current_version' => 'Sie verwenden eine ältere Version als die zur Zeit verfügbare Version [latestversion].',
'no_default_keywords' => 'Keine Vorlagen vorhanden',
'no_docs_checked_out' => 'Keine Dokumente ausgecheckt',
'no_docs_draft' => '',
'no_docs_expired' => 'Keine abgelaufenen Dokumente',
'no_docs_locked' => 'Keine Dokumente gesperrt.',
'no_docs_needs_correction' => 'Keine Dokumente, die korrigiert werden müssen',
'no_docs_obsolete' => '',
'no_docs_rejected' => 'Keine Dokumente abgelehnt.',
'no_docs_to_approve' => 'Es gibt zur Zeit keine Dokumente, die eine Freigabe erfordern.',
'no_docs_to_look_at' => 'Keine Dokumente, nach denen geschaut werden müsste.',
'no_docs_to_receipt' => 'Keine Dokumentenempfangsbestätigung erforderlich',
'no_docs_to_review' => 'Es gibt zur Zeit keine Dokumente, die eine Prüfung erfordern.',
'no_docs_to_revise' => 'Es gibt zur Zeit keine Dokumente, die erneut geprüft werden müssen.',
'no_email_or_login' => 'Login und E-Mail müssen eingegeben werden',
'no_fulltextindex' => 'Kein Volltext-Index verfügbar',
'no_groups' => 'keine Gruppen',
'no_group_members' => 'Diese Gruppe hat keine Mitglieder',
'no_linked_files' => 'Keine verknüpften Dokumente',
'no_previous_versions' => 'Keine anderen Versionen gefunden',
'no_receipt_needed' => 'Es gibt zur Zeit keine Dokumente, die eine Empfangsbestätigung erfordern.',
'no_review_needed' => 'Keine offenen Prüfungen.',
'no_revision_needed' => 'Es gibt zur Zeit keine Dokumente, die eine erneute Prüfung erfordern.',
'no_revision_planed' => 'Keine Wiederholungsprüfung des Dokuments eingeplant.',
'no_update_cause_locked' => 'Sie können daher im Moment diese Datei nicht aktualisieren. Wenden Sie sich an den Benutzer, der die Sperrung eingerichtet hat',
'no_user_image' => 'Kein Bild vorhanden',
'no_version_check' => 'Ein Check auf neuere Versionen von SeedDMS ist fehlgeschlagen. Dies könnte daran liegen, dass allow_url_fopen in der PHP-Konfiguration auf 0 gesetzt ist.',
'no_version_modification' => 'Keine Modifikationen an einer Version',
'no_workflows' => 'Sie haben bisher keinen Workflow erstellt',
'no_workflow_available' => 'Kein Workflow verfügbar',
'objectcheck' => 'Ordner- und Dokumentenprüfung',
'object_check_critical' => 'Kritische Fehler',
'object_check_warning' => 'Warnungen',
'obsolete' => 'veraltet',
'october' => 'Oktober',
'old' => 'Alt',
'only_jpg_user_images' => 'Es sind nur JPG-Bilder erlaubt',
'operation_disallowed' => 'Operation nicht erlaubt',
'orderby' => 'Sortiert nach',
'orderby_date_asc' => 'Nach Datum (aufsteigend)',
'orderby_date_desc' => 'Nach Datum (absteigend)',
'orderby_id_asc' => 'Nach Id (aufsteigend)',
'orderby_id_desc' => 'Nach Id (absteigend)',
'orderby_name_asc' => 'Nach Name (aufsteigend)',
'orderby_name_desc' => 'Nach Name (absteigend)',
'orderby_unsorted' => 'Unsortiert',
'order_by_sequence_off' => 'Die Sortierung nach Folge ist in den Einstellungen ausgeschaltet. Wenn dieser Parameter wirksam sein soll, muss sie wieder eingeschaltet werden.',
'original_filename' => 'Original filename',
'overall_indexing_progress' => 'Gesamtfortschritt bei der Indizierung',
'owner' => 'Besitzer',
'ownership_changed_email' => 'Besitzer geändert',
'ownership_changed_email_body' => 'Besitzer geändert

Dokument: [name]
Elternordner: [folder_path]
Bisheriger Besitzer: [old_owner]
Neuer Besitzer: [new_owner]
Benutzer: [username]
URL: [url]',
'ownership_changed_email_body_html' => '<p>Besitzer geändert</p>

<p>Dokument: [name]<br />
Elternordner: [folder_path]<br />
Bisheriger Besitzer: [old_owner]<br />
Neuer Besitzer: [new_owner]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'ownership_changed_email_subject' => '[sitename]: [name] - Besitzer geändert',
'password' => 'Passwort',
'password_already_used' => 'Passwort schon einmal verwendet',
'password_expiration' => 'Ablauf eines Passworts',
'password_expiration_text' => 'Ihr Passwort ist abgelaufen. Bitte ändern sie es, um SeedDMS weiter benutzen zu können.',
'password_expired' => 'Passwort ist abgelaufen',
'password_expires_in_days' => 'Passwort läuft in %s Tagen ab.',
'password_forgotten' => 'Passwort vergessen',
'password_forgotten_email_body' => 'Sehr geehrter Anwender von SeedDMS,

wir haben einen Anfrage zum Zurücksetzen Ihres Passworts erhalten.

Dies kann durch den folgenden Link erfolgen:

[url_prefix]out/out.ChangePassword.php?hash=[hash]

Sollen Sie danach immer noch Probleme bei der Anmeldung haben, dann kontaktieren Sie bitte Ihren Adminstrator.',
'password_forgotten_email_body_html' => '<p>Sehr geehrter Anwender von SeedDMS,</p>

<p>wir haben einen Anfrage zum Zurücksetzen Ihres Passworts erhalten.</p>

<p>Dies kann durch den folgenden Link erfolgen:</p>

<p>[url_prefix]out/out.ChangePassword.php?hash=[hash]</p>

<p>Sollen Sie danach immer noch Probleme bei der Anmeldung haben, dann kontaktieren Sie bitte Ihren Adminstrator.</p>',
'password_forgotten_email_subject' => '[sitename]: Passwort vergessen',
'password_forgotten_invalid_hash' => 'Ungültiger Hash-Wert',
'password_forgotten_invalid_hash_title' => 'Ungültiger Hash-Wert',
'password_forgotten_send_hash' => 'Anweisungen zum weiteren Vorgehen wurden an die E-Mail Adresse des Benutzers versandt',
'password_forgotten_text' => 'Füllen Sie bitte untenstehendes Formular aus. Weitere Anweisungen erhalten Sie dann in einer E-Mail die an Sie gesandt wird',
'password_forgotten_title' => 'Passwort gesendet',
'password_mismatch_error' => 'Passwörter sind nicht identisch',
'password_mismatch_error_title' => 'Passwörter sind nicht identisch',
'password_repeat' => 'Passwort wiederholen',
'password_send' => 'Passwort verschickt',
'password_send_text' => 'Ihr neues Passwort wurde an die angegebene E-Mail-Adresse versandt, wenn ein Benutzer mit diesem Login und dieser E-Mail-Adresse existiert. Sollten Sie innerhalb der nächsten Minuten keine E-Mail bekommen, dann überprüfen Sie nochmal die Angaben und wiederholen Sie den Vorgang.',
'password_strength' => 'Passwortstärke',
'password_strength_insuffient' => 'Ungenügend starkes Passwort',
'password_wrong' => 'Falsches Passwort',
'pdf_converters' => 'PDF Konvertierer',
'pending_approvals' => 'Ausstehende Freigaben',
'pending_receipt' => 'Ausstehende Empfangsbestätigungen',
'pending_reviews' => 'Ausstehende Prüfungen',
'pending_revision' => 'Ausstehende Wiederholungsprüfungen',
'pending_workflows' => 'Ausstehende Workflows',
'personal_default_keywords' => 'Persönliche Stichwortlisten',
'php_info' => 'Informationen über PHP',
'pl_PL' => 'Polnisch',
'possible_substitutes' => 'Vertreter',
'preset_expires' => 'Fester Ablaufzeitpunkt',
'preview' => 'Vorschau',
'preview_converters' => 'Vorschau Dokumentenumwandlung',
'preview_images' => 'Vorschaubilder',
'preview_markdown' => 'Markdown',
'preview_pdf' => 'Vorschau als PDF',
'preview_plain' => 'Text',
'previous_state' => 'Voriger Status',
'previous_versions' => 'Vorhergehende Versionen',
'process' => 'Prozess',
'process_without_user_group' => 'Prozesse ohne Benutzer/Gruppe',
'pt_BR' => 'Portugiesisch (BR)',
'quota' => 'Quota',
'quota_exceeded' => 'Ihr maximal verfügbarer Plattenplatz wurde um [bytes] überschritten.',
'quota_is_disabled' => 'Quota-Unterstützung ist zur Zeit ausgeschaltet. Benutzer-Quota werden ignoriert bis Quota-Unterstützung in den Einstellungen eingeschaltet wird.',
'quota_warning' => 'Ihr maximal verfügbarer Plattenplatz wurde um [bytes] überschritten. Bitte löschen Sie Dokumente oder ältere Versionen.',
'receipts_accepted' => '[no_receipts] Empfangsbestätigungen',
'receipts_accepted_latest' => '(davon [no_receipts] in letzter Version)',
'receipts_not_touched' => '[no_receipts] offene Empfangsbestätigungen',
'receipts_not_touched_latest' => '(davon [no_receipts] in letzter Version)',
'receipts_rejected' => '[no_receipts] abgelehnte Empfangsbestätigungen',
'receipts_rejected_latest' => '(davon [no_receipts] in letzter Version)',
'receipts_without_group' => 'Empfangsbestätigungen ohne Gruppe',
'receipts_without_user' => 'Empfangsbestätigungen ohne Benutzer',
'receipt_deletion_email_body' => 'Benutzer von Liste der Empfänger gelöscht

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Empfänger: [recipient]
Benutzer: [username]
URL: [url]',
'receipt_deletion_email_body_html' => '<p>Benutzer von Liste der Empfänger gelöscht</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Empfänger: [recipient]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'receipt_deletion_email_subject' => '[sitename]: [name] - Empfänger gelöscht',
'receipt_log' => 'Protokoll der Empfangsbestätigungen',
'receipt_request_email_body' => 'Aufforderung zur Empfangsbestätigung

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'receipt_request_email_body_html' => '<p>Aufforderung zur Empfangsbestätigung</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]<p>',
'receipt_request_email_subject' => '[sitename]: [name] - Aufforderung zur Empfangsbestätigung',
'receipt_status' => 'Status',
'receipt_submit_email_body' => 'Empfang bestätigt

Dokument: [name]
Version: [version]
Status: [status]
Kommentar: [comment]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'receipt_submit_email_body_html' => '<p>Empfang bestätigt</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Status: [status]<br />
Kommentar: [comment]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'receipt_submit_email_subject' => '[sitename]: [name] - Empfang bestätigt',
'receipt_summary' => 'Übersicht Bestätigungen',
'receipt_update_failed' => 'Setzen der Empfangsbestätigung fehlgeschlagen',
'recent_uploads' => 'Letzte Uploads',
'reception' => 'Empfangsbestätigung',
'reception_acknowleged' => 'Empfang bestätigt',
'reception_noaction' => 'Keine Aktion',
'reception_rejected' => 'Empfang abgelehnt',
'recipients' => 'Empfänger',
'recipient_already_removed' => '',
'record_type' => 'Typ',
'redraw' => 'Neu zeichnen',
'refresh' => 'Aktualisieren',
'rejected' => 'abgelehnt',
'released' => 'freigegeben',
'removed_approver' => 'ist von der Freigeber-Liste entfernt worden.',
'removed_file_email' => 'Anhang gelöscht',
'removed_file_email_body' => 'Anhang gelöscht

Dokument: [document]
Benutzer: [username]
URL: [url]',
'removed_file_email_body_html' => '<p>Anhang gelöscht</p>

<p>Dokument: [document]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'removed_file_email_subject' => '[sitename]: [document] - Anhang gelöscht',
'removed_recipient' => 'ist von der Empfängerliste entfernt worden',
'removed_reviewer' => 'ist von der Prüfer-Liste entfernt worden.',
'removed_revisor' => 'ist von der Liste der Wiederholungsprüfer entfernt worden.',
'removed_workflow_email_body' => 'Workflow von Dokumentenversion entfernt.

Dokument: [name]
Version: [version]
Workflow: [workflow]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'removed_workflow_email_body_html' => '<p>Workflow von Dokumentenversion entfernt.</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'removed_workflow_email_subject' => '[sitename]: [name] - Workflow von Dokumentenversion',
'removeFolderFromDropFolder' => 'Ordner nach Import entfernen',
'remove_approval_log' => 'Einzelne Freigabe entfernen',
'remove_marked_files' => 'Markierte Dateien löschen',
'remove_review_log' => 'Einzelne Prüfung entfernen',
'repaired' => 'repariert',
'repairing_objects' => 'Repariere Dokumente und Ordner.',
'replace_content_email_body' => 'Die letzte Version des Dokuments wurde ersetzt.

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'replace_content_email_body_html' => '<p>Die letzte Version des Dokuments wurde ersetzt.</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]v
URL: [url]</p>',
'replace_content_email_subject' => '[sitename]: [name] - Dokumentenversion ersetzt',
'request_workflow_action_email_body' => 'Der Workflow hat einen Status erreicht welcher Ihre Aktion benötigt.

Dokument: [name]
Version: [version]
Workflow: [workflow]
Aktueller Status: [current_state]
Übergeordneter Ordner: [folder_path]
Benutzer: [username]
URL: [url]',
'request_workflow_action_email_body_html' => '<p>Der Workflow hat einen Status erreicht welcher Ihre Aktion benötigt.</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Aktueller Status: [current_state]<br />
Übergeordneter Ordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'request_workflow_action_email_subject' => '[sitename]: [name] - Workflow-Aktion erforderlich',
'reset_checkout' => 'Auschecken beenden',
'restrict_access' => 'Kein Zugriff auf',
'results_page' => 'Ergebnis-Seite',
'return_from_subworkflow' => 'Rückkehr aus Sub-Workflow',
'return_from_subworkflow_email_body' => 'Rückkehr vom Subworkflow

Dokument: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'return_from_subworkflow_email_body_html' => '<p>Rückkehr vom Subworkflow</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Subworkflow: [subworkflow]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'return_from_subworkflow_email_subject' => '[sitename]: [name] - Rückkehr vom Subworkflow',
'reverse_links' => 'Dokumente, die eine Verknüpfung zu diesem Dokument haben',
'reviewers' => 'Prüfer',
'reviewer_already_assigned' => 'Prüfer bereits zugewiesen',
'reviewer_already_removed' => 'Prüfer wurde bereits aus dem Prüfvorgang entfernt oder hat die Prüfung bereits abgeschlossen',
'reviews_accepted' => '[no_reviews] Prüfungen',
'reviews_accepted_latest' => '(davon [no_reviews] in letzter Version)',
'reviews_not_touched' => '[no_reviews] offene Prüfungen',
'reviews_not_touched_latest' => '(davon [no_reviews] in letzter Version)',
'reviews_rejected' => '[no_reviews] abgelehnte Prüfungen',
'reviews_rejected_latest' => '(davon [no_reviews] in letzter Version)',
'reviews_without_group' => 'Prüfungen ohne Gruppe',
'reviews_without_user' => 'Prüfungen ohne Benutzer',
'review_deletion_email' => 'Prüfungsaufforderung gelöscht',
'review_deletion_email_body' => 'Prüfungsaufforderung gelöscht

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'review_deletion_email_body_html' => '<p>Prüfungsaufforderung gelöscht</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'review_deletion_email_subject' => '[sitename]: [name] - Prüfungsaufforderung gelöscht',
'review_file' => 'Datei',
'review_group' => 'Gruppe: prüfen',
'review_log' => 'Prüfungsprotokoll',
'review_request_email' => 'Aufforderung zur Prüfung',
'review_request_email_body' => 'Aufforderung zur Prüfung

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'review_request_email_body_html' => '<p>Aufforderung zur Prüfung</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'review_request_email_subject' => '[sitename]: [name] - Aufforderung zur Prüfung',
'review_status' => 'Status',
'review_submit_email' => 'Prüfung ausgeführt',
'review_submit_email_body' => 'Prüfung ausgeführt

Dokument: [name]
Version: [version]
Status: [status]
Kommentar: [comment]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'review_submit_email_body_html' => '<p>Prüfung ausgeführt</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Status: [status]<br />
Kommentar: [comment]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'review_submit_email_subject' => '[sitename]: [name] - Prüfung ausgeführt',
'review_summary' => 'Übersicht Prüfungen',
'review_update_failed' => 'Störung bei Aktualisierung des Prüfstatus. Aktualisierung gescheitert.',
'revise_document' => 'Wiederholungsprüfung',
'revise_document_on' => 'Nächste Wiederholungsprüfung des Dokuments am [date]',
'revision' => 'Wiederholungsprüfung',
'revisions_accepted' => '[no_revisions] Wiederholungsprüfungen',
'revisions_accepted_latest' => '(davon [no_revisions] in letzter Version)',
'revisions_not_touched' => '[no_revisions] offene Wiederholungspüfungen',
'revisions_not_touched_latest' => '(davon [no_revisions] in letzter Version)',
'revisions_pending' => '[no_revisions] zukünftige Wiederholungsprüfungen',
'revisions_pending_latest' => '(davon [no_revisions] in letzter Version)',
'revisions_rejected' => '[no_revisions] abgelehnte Wiederholungsprüfungen',
'revisions_rejected_latest' => '(davon [no_revisions] in letzter Version)',
'revisions_without_group' => 'Wiederholungsprüfungen ohne Gruppe',
'revisions_without_user' => 'Wiederholungsprüfungen ohne Benutzer',
'revision_date' => 'Datum der Wiederholungsprüfung',
'revision_log' => 'Protokoll der erneuten Prüfung',
'revision_request_email_body' => 'Aufforderung zur Wiederholungsprüfung

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'revision_request_email_body_html' => '<p>Aufforderung zur Wiederholungsprüfung</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'revision_request_email_subject' => '[sitename]: [name] - Aufforderung zur Wiederholungsprüfung',
'revision_status' => 'Status',
'revision_submit_email_body' => 'Erneute Freigabe erteilt

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Status: [status]
Kommentar: [comment]
Benutzer: [username]
URL: [url]',
'revision_submit_email_body_html' => '<p>Erneute Freigabe erteilt</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Status: [status]<br />
Kommentar: [comment]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'revision_submit_email_subject' => '[sitename]: [name] - Erneute Freigabe erteilt',
'revision_summary' => 'Übersicht Wiederholungsprüfungen',
'revisors' => 'Wiederholungsprüfer',
'revisor_already_assigned' => 'Benutzer bereits als Wiederholungsprüfer eingetragen.',
'revisor_already_removed' => 'Wiederholungsprüfer wurde bereits vom Prozess ausgeschlossen oder hat das Dokument bereits geprüft.',
'rewind_workflow' => 'Zurück zum Anfangszustand',
'rewind_workflow_email_body' => 'Workflow wurde zurückgestellt

Dokument: [name]
Version: [version]
Workflow: [workflow]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'rewind_workflow_email_body_html' => '<p>Workflow wurde zurückgestellt</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'rewind_workflow_email_subject' => '[sitename]: [name] - Workflow wurde zurückgestellt',
'rewind_workflow_warning' => 'Wenn Sie einen Workflow in den Anfangszustand zurückversetzen, dann werden alle bisherigen Aktionen und Kommentare unwiederbringlich gelöscht.',
'rm_attrdef' => 'Attributdefinition löschen',
'rm_attrdefgroup' => 'Diese Attributgruppe löschen',
'rm_attr_value' => 'Wert entfernen',
'rm_default_keyword_category' => 'Kategorie löschen',
'rm_document' => 'Löschen',
'rm_document_category' => 'Lösche Kategorie',
'rm_event' => 'Ereignis löschen',
'rm_file' => 'Datei Löschen',
'rm_folder' => 'Löschen',
'rm_from_clipboard' => 'Aus Zwischenablage löschen',
'rm_group' => 'Diese Gruppe löschen',
'rm_role' => 'Diese Rolle löschen',
'rm_task' => 'Task löschen',
'rm_transmittal' => 'Dokumentenliste entfernen',
'rm_transmittalitem' => 'Eintrag löschen',
'rm_user' => 'Benutzer löschen',
'rm_user_from_processes' => 'Benutzer aus Prozessen löschen',
'rm_version' => 'Version löschen',
'rm_workflow' => 'Lösche Workflow',
'rm_workflow_action' => 'Lösche Workflow-Aktion',
'rm_workflow_state' => 'Lösche Workflow-Status',
'rm_workflow_warning' => 'Sie möchten den Workflow eines Dokuments löschen. Dies kann nicht rückgängig gemacht werden.',
'role' => 'Rolle',
'role_admin' => 'Administrator',
'role_guest' => 'Gast',
'role_info' => 'Information',
'role_management' => 'Rollenverwaltung',
'role_name' => 'Name',
'role_type' => 'Typ der Rolle',
'role_user' => 'Benutzer',
'ro_RO' => 'Rumänisch',
'run_subworkflow' => 'Sub-Workflow starten',
'run_subworkflow_email_body' => 'Subworkflow wurde gestartet

Dokument: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'run_subworkflow_email_body_html' => '<p>Subworkflow wurde gestartet</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Subworkflow: [subworkflow]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'run_subworkflow_email_subject' => '[sitename]: [name] - Subworkflow wurde gestartet',
'ru_RU' => 'Russisch',
'saturday' => 'Samstag',
'saturday_abbr' => 'Sa',
'save' => 'Speichern',
'scheduler_class' => 'Klasse',
'scheduler_class_description' => 'Beschrebung',
'scheduler_class_parameter' => 'Parameter',
'scheduler_class_tasks' => 'Tasks der Klasse',
'scheduler_task_mgr' => 'Planer',
'search' => 'Suchen',
'search_fulltext' => 'Suche im Volltext',
'search_in' => 'Suchen in',
'search_mode' => 'Suchmodus',
'search_mode_and' => 'alle Begriffe',
'search_mode_documents' => 'Nur Dokumente',
'search_mode_folders' => 'Nur Ordner',
'search_mode_or' => 'mind. ein Begriff',
'search_no_results' => 'Die Suche lieferte leider keine Treffer.',
'search_query' => 'Suchbegriffe',
'search_report' => 'Die Suche lieferte [doccount] Dokumente und [foldercount] Ordner in [searchtime] Sek.',
'search_report_fulltext' => 'Die Suche lieferte [doccount] Dokumente',
'search_resultmode' => 'Ergebnis',
'search_resultmode_both' => 'Dokumente und Ordner',
'search_results' => 'Suchergebnis',
'search_results_access_filtered' => 'Suchresultate können Inhalte enthalten, zu welchen der Zugang verweigert wurde.',
'search_time' => 'Dauer: [time] sek.',
'seconds' => 'Sekunden',
'seeddms_info' => 'Informationen über SeedDMS',
'seeddms_version' => 'SeedDMS Version',
'selection' => 'Auswahl',
'select_attrdef' => 'Attributdefinition auswählen',
'select_attrdefgrp_show' => 'Anzeigeort auswählen',
'select_attribute_value' => 'Attributwert auswählen',
'select_category' => 'Klicken zur Auswahl einer Kategorie',
'select_group' => 'Gruppe auswählen',
'select_groups' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_approvers' => 'Klicken zur Auswahl einer Freigabegruppe',
'select_grp_ind_approvers' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_ind_notification' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_ind_recipients' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_ind_reviewers' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_ind_revisors' => 'Klicken zur Auswahl einer Gruppe',
'select_grp_notification' => 'Klicken zur Auswahl einer Beobachtergruppe',
'select_grp_recipients' => 'Klicken zur Auswahl einer Empfängergruppe',
'select_grp_reviewers' => 'Klicken zur Auswahl einer Prüfgruppe',
'select_grp_revisors' => 'Klicken zur Auswahl einer Wiederholungsprüfgruppe',
'select_ind_approvers' => 'Klicken zur Auswahl eines Freigebers',
'select_ind_notification' => 'Klicken zur Auswahl eines Beobachters',
'select_ind_recipients' => 'Klicken zur Auswahl eines Empfängers',
'select_ind_reviewers' => 'Klicken zur Auswahl eines Prüfers',
'select_ind_revisors' => 'Klicken zur Auswahl eines Wiederholungsprüfers',
'select_mimetype' => 'Klicken zur Auswahl eines Mimetypes',
'select_one' => 'Bitte wählen',
'select_owner' => 'Klicken zur Auswahl eines Besitzers',
'select_record_type' => 'Typ auswählen',
'select_status' => 'Klicken zur Auswaohl des Dokumentstatus',
'select_user' => 'Benutzer auswählen',
'select_users' => 'Klicken zur Auswahl eines Benutzers',
'select_value' => 'Wert auswählen',
'select_workflow' => 'Workflow auswählen',
'send_email' => 'E-Mail verschicken',
'send_login_data' => 'Sende Login-Daten',
'send_login_data_body' => 'Login-Daten

Login: [login]
Name: [username]

[comment]

Sollten Sie kein Passwort bekommen haben, dann nutzen Sie bitte die Passwort-Vergessen-Funktion auf der Anmeldeseite, um ein neues Passwort zu setzen.',
'send_login_data_subject' => '[sitename]: [login] - Ihre Login-Daten',
'send_test_mail' => 'Sende Test-E-mail',
'september' => 'September',
'sequence' => 'Reihenfolge',
'seq_after' => 'Nach "[prevname]"',
'seq_end' => 'Ans Ende',
'seq_keep' => 'Beibehalten',
'seq_start' => 'An den Anfang',
'sessions' => 'Benutzer Online',
'setDateFromFile' => 'Datum von importierter Datei übernehmen',
'setDateFromFolder' => 'Datum von importierten Verzeichnis übernehmen',
'settings' => 'Einstellungen',
'settings_activate_module' => 'Modul aktivieren',
'settings_activate_php_extension' => 'PHP-Erweiterung aktivieren',
'settings_adminIP' => 'Admin IP',
'settings_adminIP_desc' => 'Wenn hier eine IP-Nummer eingetragen wird, kann eine Anmeldung als Administrator nur von dieser Adresse erfolgen. Funktioniert nur mit Anmeldung über die Datenbank (nicht LDAP)',
'settings_Advanced' => 'Erweitert',
'settings_advancedAcl' => 'Erweiterte Zugriffsrechte',
'settings_advancedAcl_desc' => 'Erweiterte Zugriffsrechte erlauben bestimmte Module der Software ein- und auszuschalten. Sie können nicht den Zugriff auf Dokumente und Ordner einschränken.',
'settings_allowChangeRevAppInProcess' => 'Erlaube das Ändern der Prüfer/Freigeber nachdem der Prozess gestartet wurde.',
'settings_allowChangeRevAppInProcess_desc' => 'Voreingestellt können Prüfer und Freigeber nicht mehr verändert werden, wenn eine Freigabe oder Prüfung ausgeführt wurde. Diese Option erlaubt es Administratoren auch nach der ersten Prüfung oder Freigabe die Prüfer und Freigeber zu verändern, bis das Dokument endgültig freigegeben oder abgelehnt ist.',
'settings_allowReviewerOnly' => 'Erlaube nur Prüfer zu setzen',
'settings_allowReviewerOnly_desc' => 'Anwählen, um zu erlauben, dass nur ein Prüfer aber kein Freigeber beim traditionellen Workflow gesetzt werden darf.',
'settings_apache_mod_rewrite' => 'Apache - Module Rewrite',
'settings_apiKey' => 'Authentifizierungsschḻüssel für REST API',
'settings_apiKey_desc' => 'Dieser Schlüssel wird zur alternative Authentifizierung in der REST API verwendet. Wählen Sie eine 32 Zeichen lange Zeichenkette.',
'settings_apiOrigin' => 'Erlaubte Herkunft der API Aufrufe',
'settings_apiOrigin_desc' => 'Eine semicolon-separierte Liste von Adressen, denen ein Zugriff auf die REST API erlaubt ist. Jede Adresse muss in der Form <Protokoll>://<domain>[:<port>] angegeben werden. Der Port kann ausgelassen werden. Bleibt dieses Feld leer, dann ist der Zugriff uneingeschränkt.',
'settings_apiUserId' => 'Benutzer für die REST API',
'settings_apiUserId_desc' => 'Dieser Benutzer wird für Zugriffe über die REST API genutzt, sofern eine Authentifizierung über den konifigurierten API Schlüssel erfolgt.',
'settings_Authentication' => 'Authentifikations-Einstellungen',
'settings_autoLoginUser' => 'Automatisches Login',
'settings_autoLoginUser_desc' => 'Verwende den Benutzer mit der angegebenen Id, sofern man nicht bereits angemeldet ist. Solch ein Zugriff erzeugt keine eigene Sitzung.',
'settings_available_languages' => 'Verfügbare Sprachen',
'settings_available_languages_desc' => 'Nur die hier ausgewählten Sprachen werden geladen und erscheinen bei der Sprachauswahl. Die voreingestellte Sprache wird immer geladen.',
'settings_backupDir' => 'Sicherungs-Verzeichnis',
'settings_backupDir_desc' => 'Verzeichnis in dem das Backup-Tool die Sicherungen ablegt. Wenn hier kein Wert gesetzt wird oder auf das Verzeichnis nicht zugriffen werden kann, dann werden die Sicherungen im Content-Verzeichnis abgelegt.',
'settings_cacheDir' => 'Cache Verzeichnis',
'settings_cacheDir_desc' => 'Verzeichnis in dem Vorschaubilder abgelegt werden. Dies sollte ein Verzeichnis sein, auf das man über den Web-Browser keinen direkten Zugriff hat.',
'settings_Calendar' => 'Kalender-Einstellungen',
'settings_calendarDefaultView' => 'Kalender Standardansicht',
'settings_calendarDefaultView_desc' => 'Voreingestellte Ansicht des Kalenders',
'settings_cannot_disable' => 'Datei ENABLE_INSTALL_TOOL konnte nicht gelöscht werden.',
'settings_checkOutDir' => 'Verzeichnis für ausgecheckte Dokumente',
'settings_checkOutDir_desc' => 'Dies ist das Verzeichnis, in das Dokumenteninhalte bei einem Check out kopiert werden. Wenn dieses Verzeichnis für die Benutzer erreichbar ist, können die Dateien editiert und dann wieder eingecheckt werden.',
'settings_cmdTimeout' => 'Timeout für externe Programme',
'settings_cmdTimeout_desc' => 'Diese Zeit in Sekunden legt fest, wann ein externes Programm (z.B. für die Erstellung des Volltext-Index) beendet wird.',
'settings_conf_field_not_editable' => 'Dieser Wert ist nicht editierbar',
'settings_contentDir' => 'Content-Verzeichnis',
'settings_contentDir_desc' => 'Verzeichnis, in dem die Dokumente gespeichert werden. Sie sollten ein Verzeichnis wählen, das nicht durch den Web-Server erreichbar ist.',
'settings_contentOffsetDir' => 'Content Offset Directory',
'settings_contentOffsetDir_desc' => 'Die Dokumente werden nicht direkt im Content-Verzeichnis, sondern in einem Unterverzeichnis angelegt. Der Name dieses Verzeichnis ist beliebig, wird aber historisch bedingt oft auf \'1048576\' gesetzt.',
'settings_convertToPdf' => 'Konvertiere Dokument für die Vorschau nach PDF',
'settings_convertToPdf_desc' => 'Wenn das Dokumentenformat vom Browser nicht unterstützt wird, wird die PDF konvertierte Version angezeigt.',
'settings_cookieLifetime' => 'Lebensdauer des Cookies',
'settings_cookieLifetime_desc' => 'Die Lebensdauer des Cookies für die Sitzungsverwaltung. Wenn dieser Wert auf 0 gesetzt wird, dann wird der Cookie beim Schließen des Browsers gelöscht.',
'settings_coreDir' => 'Core SeedDMS Verzeichnis',
'settings_coreDir_desc' => 'Pfad zum PEAR-Paket SeedDMS_Core (optional). Lassen Sie diese Einstellung leer, wenn SeedDMS_Core ohnehin von PHP gefunden wird, weil es beispielweise im \'Extra PHP Include-Path\' installiert ist.',
'settings_createCheckOutDir' => 'Check out Verzeichnis erstellen',
'settings_createCheckOutDir_desc' => 'Check out Verzeichnis erstellen, wenn es nicht existiert.',
'settings_createdatabase' => 'Datenbank erzeugen',
'settings_createdirectory' => 'Verzeichnis erzeugen',
'settings_currentvalue' => 'Aktueller Wert',
'settings_Database' => 'Datenbank-Einstellungen',
'settings_dateformat' => 'Datumsformat',
'settings_dateformat_desc' => 'Das Datumsformat verwendet die Syntax der PHP-Funktion date()',
'settings_datetimeformat' => 'Datums/Zeitformat',
'settings_datetimeformat_desc' => 'Das Datumsformat verwendet die Syntax der PHP-Funktion date()',
'settings_dbDatabase' => 'Datenbank',
'settings_dbDatabase_desc' => 'Der Name der Datenbank, die bei der Installation von SeedDMS eingerichtet wurde. Ändern Sie diese Feld nicht, es sei denn es ist notwendig, weil Sie die Datenbank umbenannt haben.',
'settings_dbDriver' => 'Datenbank-Typ',
'settings_dbDriver_desc' => 'Der Typ der Datenbank, die bei der Installation von SeedDMS eingerichtet wurde. Ändern Sie dieses Feld nicht, es sei denn Sie migrieren die Datenbank auf einen anderen Datenbank-Server. Für eine Liste der möglichen Typen schauen Sie bitte in das Readme von ADOdb',
'settings_dbHostname' => 'Server-Name',
'settings_dbHostname_desc' => 'Der Name des Servers auf dem Ihr Datenbank-Server läuft. Ändern Sie dieses Feld nur, wenn Sie die Datenbank auf einen anderen Server transferieren.',
'settings_dbPass' => 'Passwort',
'settings_dbPass_desc' => 'Das Passwort, um auf die Datenbank zugreifen zu können.',
'settings_dbUser' => 'Benutzer',
'settings_dbUser_desc' => 'Der Benutzername, um auf die Datenbank zugreifen zu können.',
'settings_dbVersion' => 'Datenbankschema zu alt',
'settings_defaultAccessDocs' => 'Standardberechtigung für neue Dokumente',
'settings_defaultAccessDocs_desc' => 'Beim Erstellen eines neuen Dokuments wird dies als Standardberechtigung gesetzt.',
'settings_defaultDocPosition' => 'Position eines Dokuments beim Anlegen',
'settings_defaultDocPosition_desc' => 'Dies ist die voreingestellte Position eines Dokuments innerhalb eines Ordners, wenn dieses angelegt wird.',
'settings_defaultDocPosition_val_end' => 'Ende',
'settings_defaultDocPosition_val_start' => 'Anfang',
'settings_defaultFolderPosition' => 'Position eines Ordners beim Anlegen',
'settings_defaultFolderPosition_desc' => 'Dies ist die voreingestellte Position eines Ordners innerhalb eines Ordners, wenn dieser neu angelegt wird.',
'settings_defaultSearchMethod' => 'Voreingestellte Suchmethode',
'settings_defaultSearchMethod_desc' => 'Voreingestellte Suchmethode, wenn über das Suchfeld in der Menüleiste gesucht wird.',
'settings_defaultSearchMethod_valdatabase' => 'Datenbank',
'settings_defaultSearchMethod_valfulltext' => 'Volltext',
'settings_delete_install_folder' => 'Um SeedDMS nutzen zu können, müssen Sie die Datei ENABLE_INSTALL_TOOL aus dem Konfigurationsverzeichnis löschen.',
'settings_disableSelfEdit' => 'Kein Ändern des eigenen Profils',
'settings_disableSelfEdit_desc' => 'Anwählen, um das Ändern des eigenen Profiles zu verhindern.',
'settings_disable_install' => 'Lösche ENABLE_INSTALL_TOOL wenn möglich',
'settings_Display' => 'Anzeige-Einstellungen',
'settings_dropFolderDir' => 'Verzeichnis für Ablageordner',
'settings_dropFolderDir_desc' => 'Dieses Verzeichnis kann dazu benutzt werden Dokumente auf dem Server abzulegen und von dort zu importieren anstatt sie über den Browser hochzuladen. Das Verzeichnis muss ein Unterverzeichnis mit dem Login-Namen des angemeldeten Benutzers beinhalten.',
'settings_Edition' => 'Funktions-Einstellungen',
'settings_editOnlineFileTypes' => 'Dateitypen für Online-Editieren',
'settings_editOnlineFileTypes_desc' => 'Dateien mit den angegebenen Endungen oder Mimetypes können Online editiert werden (benutzen Sie ausschließlich Kleinbuchstaben).',
'settings_enable2FactorAuthentication' => '2-Faktor Authentifizierung einschalten',
'settings_enable2FactorAuthentication_desc' => 'Schaltet die 2-Faktor Authentifizierung ein, welche den Google Authenticator auf dem Mobiltelefon erfordert.',
'settings_enableAcknowledgeWorkflow' => '',
'settings_enableAcknowledgeWorkflow_desc' => '',
'settings_enableAdminReceipt' => 'Admin darf Empfang bestätigen',
'settings_enableAdminReceipt_desc' => 'Anwählen, um Administratoren in der Liste der Personen für eine Empfangsbestätigung auszugeben',
'settings_enableAdminRevApp' => 'Admin darf freigeben/prüfen',
'settings_enableAdminRevApp_desc' => 'Anwählen, um Administratoren in der Liste der Prüfer und Freigeber und als Beteiligte in Workflows auszugeben',
'settings_enableCalendar' => 'Kalender einschalten',
'settings_enableCalendar_desc' => 'Kalender ein/ausschalten',
'settings_enableCancelCheckout' => 'Erlaube den Abbruch ausgecheckter Dokumente',
'settings_enableCancelCheckout_desc' => 'Auswählen, wenn es möglich sein soll auch bereits modifizierte ausgecheckte Dokumente zu verwerfen.',
'settings_enableClipboard' => 'Zwischenablage einschalten',
'settings_enableClipboard_desc' => 'Schaltet die Zwischenablage auf der \'View Folder\' Seite ein/aus',
'settings_enableConverting' => 'Dokumentenkonvertierung einschalten',
'settings_enableConverting_desc' => 'Ein/Auschalten der automatischen Konvertierung von Dokumenten',
'settings_enableDebugMode' => 'Debug Modus',
'settings_enableDebugMode_desc' => 'Einschalten, um den Debug Modus einzuschalten, der ein  weiteres Menu in den Admin-Werkzeugen hinzufügt.',
'settings_enableDropFolderList' => 'Liste der Dateien im Ablageordner im Menü',
'settings_enableDropFolderList_desc' => 'Schaltet einen Liste der im Ablageordner befindlichen Dateien als Eintrag im Menü ein.',
'settings_enableDropUpload' => 'Schnelles Hochladen einschalten',
'settings_enableDropUpload_desc' => 'Ein/Ausschalten des Bereichs auf der \'View Folder\' Seite zum Hochladen von Dateien per Drag&Drop.',
'settings_enableDuplicateDocNames' => 'Erlaube doppelte Dokumentennamen',
'settings_enableDuplicateDocNames_desc' => 'Erlaube doppelte Dokumentennamen in einem Ordner.',
'settings_enableDuplicateSubFolderNames' => 'Erlaube doppelte Namen von Unterordnern',
'settings_enableDuplicateSubFolderNames_desc' => 'Erlaube doppelte Namen von Unterordnern in einem Ordner.',
'settings_enableEmail' => 'E-Mail-Benachrichtigung aktivieren',
'settings_enableEmail_desc' => 'Automatische E-Mail-Benachrichtigung ein-/ausschalten',
'settings_enableExtensionDownload' => 'Erlaube das Herunterladen von Erweiterungen',
'settings_enableExtensionDownload_desc' => 'Anwählen, um den Download einer Extension im Extension-Manager zu erlauben.',
'settings_enableExtensionImport' => 'Erlaube Import von Erweiterungen',
'settings_enableExtensionImportFromRepository' => 'Erlaube Import von Erweiterung aus dem Repository',
'settings_enableExtensionImportFromRepository_desc' => 'Anwählen, um den Import einer Erweiterung aus dem Repositorium zu erlauben.',
'settings_enableExtensionImport_desc' => 'Wenn dies gesetzt ist, können Erweiterung durch Hochladen im Erweiterungs-Manager importiert werden.',
'settings_enableFilterReceipt' => 'Besitzer, Prüfer, ... aus Empfängerliste filtern',
'settings_enableFilterReceipt_desc' => 'Anwählen, um einige Empfänger aus der Liste zu entfernen, wenn diese als Mitglieder einer Gruppe eingetragen werden.',
'settings_enableFolderTree' => 'Verzeichnisbaum einschalten',
'settings_enableFolderTree_desc' => 'Schaltet den Verzeichnisbaum auf der \'View Folder\' Seite ein oder aus',
'settings_enableFullSearch' => 'Volltextsuche einschalten',
'settings_enableFullSearch_desc' => 'Anwählen, um die Volltextsuche mittels Lucene einzuschalten.',
'settings_enableGuestAutoLogin' => 'Automatische Anmeldung als Gast',
'settings_enableGuestAutoLogin_desc' => 'Wenn das Gast-Login und automatisches Anmelden eingeschaltet ist, dann wird der Gast-Benutzer sofort angemeldet.',
'settings_enableGuestLogin' => 'Anmeldung als Gast',
'settings_enableGuestLogin_desc' => 'Wenn Sie Gast-Logins erlauben wollen, dann wählen Sie diese Option an. Anmerkung: Gast-Logins sollten nur in einer vertrauenswürdigen Umgebung erlaubt werden.',
'settings_enableHelp' => 'Hilfe einschalten',
'settings_enableHelp_desc' => 'Ein-/Ausschalten des Hilfe-Links im Hauptmenü.',
'settings_enableLanguageSelector' => 'Sprachauswahl einschalten',
'settings_enableLanguageSelector_desc' => 'Zeige Auswahl der verfügbaren Sprachen nachdem man sich angemeldet hat.',
'settings_enableLargeFileUpload' => 'Hochladen von sehr großen Dateien ermöglichen',
'settings_enableLargeFileUpload_desc' => 'Wenn dies gesetzt ist, dann ist ebenfalls der Upload von Dokumenten durch ein java applet mit Namen \'jumploader\' ohne Begrenzung der maximalen Dateigröße möglich. Auch das Hochladen mehrerer Dokumente in einem Schritt wird dadurch ermöglicht. Das Einschalten bewirkt, dass keine http only Cookies mehr gesetzt werden.',
'settings_enableMenuTasks' => 'Aufgabenliste im Menü',
'settings_enableMenuTasks_desc' => 'Ein-/Ausschalten des Menüeintrags, der anstehenden Aufgaben des Benutzers enthält. Diese Liste beinhaltet Dokumente die geprüft, freigegeben, usw. werden müssen.',
'settings_enableMultiUpload' => 'Erlaube Hochladen mehrerer Dateien',
'settings_enableMultiUpload_desc' => 'Beim Erstellen eines neuen Dokuments können mehrere Dateien in einem Vorgang hochgeladen werden. Jede Datei erzeugt ein neues Dokument.',
'settings_enableNotificationAppRev' => 'Prűfer/Freigeber benachrichtigen',
'settings_enableNotificationAppRev_desc' => 'Setzen Sie diese Option, wenn die Prüfer und Freigeber eines Dokuments beim Hochladen einer neuen Version benachrichtigt werden sollen.',
'settings_enableNotificationWorkflow' => 'Sende Benachrichtigung an Benutzer im nächsten Workflow-Schritt',
'settings_enableNotificationWorkflow_desc' => 'Wenn diese Option eingeschaltet ist, werden die Benutzer und Gruppen, die im nächsten Workflow-Schritt aktiv werden müssen, informiert. Selbst dann, wenn Sie für das Dokument keine Benachrichtigung eingetragen haben.',
'settings_enableOwnerNotification' => 'Besitzer als Beobachter eintragen',
'settings_enableOwnerNotification_desc' => 'Setzen Sie diese Option, wenn der Besitzer eines Dokuments nach dem Hochladen in die Liste der Beobachter eingetragen werden soll.',
'settings_enableOwnerReceipt' => 'Erlaube Empfangsbestätigung durch Besitzer',
'settings_enableOwnerReceipt_desc' => 'Anwählen, um den Besitzer eines Dokuments in der Liste der Empfänger auswählbar zu machen.',
'settings_enableOwnerRevApp' => 'Erlaube Prüfung/Freigabe durch Besitzer',
'settings_enableOwnerRevApp_desc' => 'Anwählen, um den Besitzer eines Dokuments in der Liste der Prüfer/Freigeber und für Workflow-Aktionen auswählbar zu machen.',
'settings_enablePasswordForgotten' => 'Passwort-Vergessen Funktion einschalten',
'settings_enablePasswordForgotten_desc' => 'Setzen Sie diese Option, wenn Benutzer ein neues Password per E-Mail anfordern dürfen.',
'settings_enableReceiptReject' => 'Erlaube Ablehnung einer Empfangsbestätgung',
'settings_enableReceiptReject_desc' => 'Amwählen, um Empfangsbestätigungen abzulehnen.',
'settings_enableReceiptWorkflow' => 'Ermögliche Bestätigung des Dokumentenempfang',
'settings_enableReceiptWorkflow_desc' => 'Anwählen, um den Workflow zur Kenntnisnahme von Dokumenten einzuschalten',
'settings_enableRecursiveCount' => 'Rekursive Dokumenten-/Ordner-Zählung',
'settings_enableRecursiveCount_desc' => 'Wenn diese Option eingeschaltet ist, wird die Anzahl der Dokumente und Ordner in der Ordner-Ansicht rekursiv, unter Berücksichtigung der Zugriffsrechte ermittelt.',
'settings_enableRemoveRevApp' => 'Erlaube das Löschen einer Prüfung/Freigabe',
'settings_enableRemoveRevApp_desc' => 'Anwählen, um Administratoren das Löschen einer Prüfung/Freigabe zu erlauben. Dabei wird die Prüfung/Freigabe nicht aus der Datenbank gelöscht, sondern durch einen neuen Eintrag im Prüf-/Freigabeprotokoll der Anfangszustand hergestellt.',
'settings_enableRevisionOneVoteReject' => 'Ablehnung durch einen Wiederholungsprüfer',
'settings_enableRevisionOneVoteReject_desc' => 'Diese Einstellung setzen, wenn die Ablehnung einer Wiederholungsprüfung durch einen einzelnen Prüfer den Status \'Korrektur erforderlich\' setzt und nicht erst alle Prüfungen abgewartet werden, bevor ein Statuswechsel vollzogen wird.',
'settings_enableRevisionOnVoteReject' => '',
'settings_enableRevisionOnVoteReject_desc' => '',
'settings_enableRevisionWorkflow' => 'Ermögliche Wiederholungsprüfung von Dokumenten',
'settings_enableRevisionWorkflow_desc' => 'Anwählen, um den Workflow der Wiederholungsprüfung von Dokumenten nach einer einstellbaren Zeit zu ermöglichen.',
'settings_enableSelfReceipt' => 'Erlaube Empfangsbestätigung durch angemeldeten Benutzer',
'settings_enableSelfReceipt_desc' => 'Anwählen, um den aktuell angemeldeten Benutzer in der Liste der Empfänger eines Dokuments auswählbar zu machen.',
'settings_enableSelfRevApp' => 'Erlaube Prüfung/Freigabe durch angemeldeten Benutzer',
'settings_enableSelfRevApp_desc' => 'Anwählen, um den aktuell angemeldeten Benutzer in der Liste der Prüfer/Freigeber und für Workflow-Aktionen auswählbar zu machen.',
'settings_enableSessionList' => 'Liste angemeldeter Benutzer im Menü',
'settings_enableSessionList_desc' => 'Schaltet die Liste der zur Zeit angemeldeten Benutzer im Menu ein/aus.',
'settings_enableThemeSelector' => 'Auswahl des Themas',
'settings_enableThemeSelector_desc' => 'Schaltet das Auswahlmenü für die Themenauswahl in der Anmeldemaske ein oder aus.',
'settings_enableUpdateReceipt' => 'Erlaube die Änderung einer Empfangsbestätigung',
'settings_enableUpdateReceipt_desc' => 'Anwählen, um dem Benutzer, der die Empfangsbestätigung erteilt hat, die Änderung der Entscheidung zu erlauben.',
'settings_enableUpdateRevApp' => 'Erlaube die Änderung einer Prüfung/Freigabe',
'settings_enableUpdateRevApp_desc' => 'Anwählen, um dem Benutzer, der die Prüfung/Freigabe durchgeführt hat, die Änderung der Entscheidung zu erlauben, solange das Dokument den Workflow-Schritt noch nicht verlassen hat.',
'settings_enableUserImage' => 'Benutzerbilder einschalten',
'settings_enableUserImage_desc' => 'Foto der Benutzer ein-/ausschalten',
'settings_enableUsersView' => 'Benutzeransicht aktivieren',
'settings_enableUsersView_desc' => 'Gruppen- und Benutzeransicht für alle Benutzer ein-/ausschalten',
'settings_enableVersionDeletion' => 'Erlaube Löschen alter Versionen',
'settings_enableVersionDeletion_desc' => 'Setzen Sie diese Option, wenn frühere Versionen eines Dokuments durch reguläre Benutzer gelöscht werden können. Administratoren dürfen dies immer.',
'settings_enableVersionModification' => 'Erlaube Modifikation von Versionen',
'settings_enableVersionModification_desc' => 'Setzen Sie diese Option, wenn Versionen eines Dokuments nach dem Hochladen noch durch reguläre Benutzer verändert werden dürfen. Administratoren dürfen dies immer.',
'settings_enableWebdavReplaceDoc' => 'Dokument beim Speichern ersetzen',
'settings_enableWebdavReplaceDoc_desc' => 'Wenn eingeschaltet, wird beim Speichern eine bestehende Dokumentenversion ersetzt und keine neue Version erzeugt. Dies erfolgt nur wenn der Benutzer, Mimetype und Dateiname unverändert zur letzten Version sind. Diese Einstellung kann hilfreich sein, wenn Programme das geöffnete Dokument in regelmäßigen Abständen speichern.',
'settings_enableXsendfile' => 'Apache xsendfile-Modul nutzen',
'settings_enableXsendfile_desc' => 'Wenn diese Option eingeschaltet ist und das Apache-Modul xsendfile installiert, wird dieses für die Auslieferung der Bilder verwendet.',
'settings_encryptionKey' => 'Verschlüsselungs-Sequenz',
'settings_encryptionKey_desc' => 'Diese Zeichenkette wird verwendet um eine eindeutige Kennung zu erzeugen, die als verstecktes Feld in einem Formular untergebracht wird. Sie dient zur Verhinderung von CSRF-Attacken.',
'settings_error' => 'Fehler',
'settings_expandFolderTree' => 'Dokumenten-Baum',
'settings_expandFolderTree_desc' => 'Auswählen, wie der Dokumenten-Baum nach der Anmeldung angezeigt wird.',
'settings_expandFolderTree_val0' => 'versteckt',
'settings_expandFolderTree_val1' => 'sichtbar und erste Ebene ausgeklappt',
'settings_expandFolderTree_val2' => 'sichtbar und komplett ausgeklappt',
'settings_ExtensionMgr' => 'Erweiterungs-Manager-Einstellungen',
'settings_Extensions' => 'Erweiterungen',
'settings_extraPath' => 'Extra PHP Include-Pfad',
'settings_extraPath_desc' => 'Pfad für zusätzliche Software. Dies ist das Verzeichnis, welches die zusätzlichen PEAR-Pakete beinhaltet.',
'settings_firstDayOfWeek' => 'Erster Tag der Woche',
'settings_firstDayOfWeek_desc' => 'Erster Tag der Woche',
'settings_footNote' => 'Text im Fuß der Seite',
'settings_footNote_desc' => 'Meldung, die im Fuß jeder Seite angezeigt wird.',
'settings_fullSearchEngine' => 'Verfahren für Volltext',
'settings_fullSearchEngine_desc' => 'Setzt das Verfahren, welches für die Volltextsuche verwendet wird.',
'settings_fullSearchEngine_vallucene' => 'Zend Lucene',
'settings_fullSearchEngine_valsqlitefts' => 'SQLiteFTS',
'settings_guestID' => 'Gastbenutzer',
'settings_guestID_desc' => 'Id des Gast-Benutzers, wenn man sich als \'guest\' anmeldet.',
'settings_guestid_is_admin' => 'Gastuser ist ein Administrator',
'settings_guestid_is_disabled' => 'Gastuser ist deaktiviert',
'settings_httpRoot' => 'HTTP Wurzelverzeichnis',
'settings_httpRoot_desc' => 'Der relative Pfad in der URL nach der Domain, also ohne http:// und den hostnamen. z.B. wenn die komplette URL http://www.example.com/seeddms/ ist, dann setzen Sie diesen Wert auf \'/seeddms/\'. Wenn die URL http://www.example.com/ ist, tragen Sie \'/\' ein.',
'settings_incItemsPerPage' => 'Zahl der Einträge, die nachgeladen werden',
'settings_incItemsPerPage_desc' => 'Wenn die Anzahl der Ordner und Dokumente beschränkt wird, dann bestimmt dieser Wert die Anzahl der nachzuladenen Objekte, wenn man sich an das Ende der View-Folder Seite bewegt. Ein Wert 0, läd die gleiche Anzahl an Objekten nach, die anfänglich geladen wurden.',
'settings_initialDocumentStatus' => 'Initialer Dokumentenstatus',
'settings_initialDocumentStatus_desc' => 'Dieser STatus wird bei Dokumenten gesetzt, die neu hinzugefügt wurden.',
'settings_initialDocumentStatus_draft' => 'Entwurf',
'settings_initialDocumentStatus_released' => 'freigegeben',
'settings_inlineEditing' => 'Editieren auf der Seite',
'settings_inlineEditing_desc' => 'Erlaubt das Ändern des Dokumentnamens direkt auf der Detailseite.',
'settings_installADOdb' => 'Installieren Sie ADOdb',
'settings_install_disabled' => 'Datei ENABLE_INSTALL_TOOL wurde gelöscht. Sie können sich nun bei SeedDMS anmeldung und mit der Konfiguration fortfahren.',
'settings_install_pear_package_log' => 'Installiere Pear package \'Log\'',
'settings_install_pear_package_webdav' => 'Installiere Pear package \'HTTP_WebDAV_Server\', if you intend to use the webdav interface',
'settings_install_success' => 'Die Installation wurde erfolgreich beendet',
'settings_install_welcome_text' => '<p>Before you start to install SeedDMS make sure you have created a file \'ENABLE_INSTALL_TOOL\' in your configuration directory, otherwise the installation will not work. On Unix-System this can easily be done with \'touch conf/ENABLE_INSTALL_TOOL\'. After you have finished the installation delete the file.</p><p>SeedDMS has very minimal requirements. You will need a mysql database or sqlite support and a php enabled web server. The pear package Log has to be installed too. For the lucene full text search, you will also need the Zend framework installed on disc where it can be found by php. For the WebDAV server you will also need the HTTP_WebDAV_Server. The path to it can later be set during installation.</p><p>If you like to create the database before you start installation, then just create it manually with your favorite tool, optionally create a database user with access on the database and import one of the database dumps in the configuration directory. The installation script can do that for you as well, but it will need database access with sufficient rights to create databases.</p>',
'settings_install_welcome_title' => 'Willkommen zur Installation von SeedDMS',
'settings_install_zendframework' => 'Installiere Zend Framework, wenn Sie die zend-basierte Volltextsuche einsetzen möchten. Anderenfalls, ignorieren Sie diese Meldung und fahren Sie mit der Installation fort.',
'settings_invalid_guestid' => 'Ungültiger Gastbenutzer',
'settings_language' => 'Voreingestellte Sprache',
'settings_language_desc' => 'Voreingestellte Sprache (entspricht dem Unterverzeichnis im Verzeichnis \'languages\')',
'settings_libraryFolder' => 'Bibliotheksordner',
'settings_libraryFolder_desc' => 'Ordner aus dem Dokumente für neue Dokumente kopiert werden können.',
'settings_logFileEnable' => 'Log-Datei ein-/ausschalten',
'settings_logFileEnable_desc' => 'Anwählen, um alle Aktionen in einer Log-Datei im Datenverzeichnis zu speichern.',
'settings_logFileRotation' => 'Rotation der Log-Datei',
'settings_logFileRotation_desc' => 'Zeitraum nachdem eine Rotation der Log-Datei durchgeführt wird',
'settings_loginFailure' => 'Anmeldefehlversuche',
'settings_loginFailure_desc' => 'Konto nach n Anmeldefehlversuchen sperren.',
'settings_luceneClassDir' => 'Lucene SeedDMS Verzeichnis',
'settings_luceneClassDir_desc' => 'Pfad zum PEAR-Paket SeedDMS_Lucene (optional). Lassen Sie diese Einstellung leer, wenn SeedDMS_Lucene ohnehin von PHP gefunden wird, weil es beispielweise im \'Extra PHP Include-Path\' installiert ist.',
'settings_luceneDir' => 'Verzeichnis für Volltext-Index',
'settings_luceneDir_desc' => 'Verzeichnis in dem der Lucene-Index abgelegt wird.',
'settings_maxDirID' => 'Max. Anzahl Unterverzeichnisse',
'settings_maxDirID_desc' => 'Maximale Anzahl der Unterverzeichnisse in einem Verzeichnis. Ändern Sie diesen Wert nur, wenn Sie genau wissen was Sie tun! Voreingestellt ist 0.',
'settings_maxExecutionTime' => 'Max. Ausführungszeit (s)',
'settings_maxExecutionTime_desc' => 'Maximale Zeit in Sekunden bis ein Skript beendet wird.',
'settings_maxItemsPerPage' => 'Max. Anzahl der Einträge auf einer Seite',
'settings_maxItemsPerPage_desc' => 'Begrenzt die Anzahl der Ordner und Dokumente auf der View-Folder Seite. Weitere Objekte werden geladen, wenn man an das Ende der Seite rollt. Setze diesen Wert auf 0, um immer alle Objekte anzuzeigen.',
'settings_maxRecursiveCount' => 'Max. Anzahl Anzahl rekursiver Dokumente/Ordner.',
'settings_maxRecursiveCount_desc' => 'Dies ist die maximale Anzahl der Dokumente und Ordner die auf Zugriffsrechte geprüft werden, wenn rekursiv gezählt wird. Wenn diese Anzahl überschritten wird, wird die Anzahl der Dokumente und Unterordner in der Ordner Ansicht geschätzt.',
'settings_maxSizeForFullText' => 'Maximale Dateigröße für sofortige Indezierung',
'settings_maxSizeForFullText_desc' => 'Alle neuen Versionen eines Dokuments, die kleiner als die konfigurierte Dateigröße in Bytes sind, werden sofort indiziert. In allen anderen Fällen werden nur die Metadaten erfasst.',
'settings_maxUploadSize' => 'Maximale Größe hochzuladener Dateien',
'settings_maxUploadSize_desc' => 'Dies ist die maximale Größe einer hochzuladenen Datei. Es begrenzt sowohl Dokumentenversionen als auch Anhänge.',
'settings_more_settings' => 'Weitere Einstellungen. Login mit admin/admin',
'settings_noDocumentFormFields' => 'Diese Felder nicht zeigen (Dokumente)',
'settings_noDocumentFormFields_desc' => 'Diese Felder werden bei der Neuanlage und beim Bearbeiten eines Dokuments nicht angezeigt. Bestehende Werte werden beibehalten.',
'settings_noFolderFormFields' => 'Diese Felder nicht anzeigen (Ordner)',
'settings_noFolderFormFields_desc' => 'Diese Felder werden bei der Neuanlage und beim Bearbeiten eines Ordners nicht angezeigt. Bestehende Werte werden beibehalten.',
'settings_notfound' => 'Nicht gefunden',
'settings_Notification' => 'Benachrichtigungen-Einstellungen',
'settings_notwritable' => 'Die Konfiguration kann nicht gespeichert werden, weil die Konfigurationsdatei nicht schreibbar ist.',
'settings_no_content_dir' => 'Content directory',
'settings_onePageMode' => 'Einseiten-Modus',
'settings_onePageMode_desc' => 'Der Einseiten-Modus schaltet javascript auf der ViewFolder-Seite ein, der die Ordner- und Dokumentenliste, die Navigation, etc. aktualisiert, wenn auf einen Ordner geklickt wird.',
'settings_overrideMimeType' => 'Überschreibe MimeType',
'settings_overrideMimeType_desc' => 'Überschreibe den MimeType, der vom Browser beim Hochladen einer Datei übertragen wird. Der neue MimeType wird von SeedDMS selbst ermittelt.',
'settings_overrideTheme' => 'Theme überschreiben',
'settings_overrideTheme_desc' => 'Einschalten, um die Einstellung des Themes im Benutzerkonto durch die Einstellung in der Konfiguration zu überschreiben.',
'settings_partitionSize' => 'Partitionsgröße',
'settings_partitionSize_desc' => 'Größe der partiellen Uploads in Bytes durch den Jumploader. Wählen Sie diesen Wert nicht größer als maximale Upload-Größe, die durch den Server vorgegeben ist.',
'settings_passwordExpiration' => 'Passwortverfall',
'settings_passwordExpiration_desc' => 'Die Zahl der Tage nach der ein Passwort verfällt und neu gesetzt werden muss. 0 schaltet den Passwortverfall aus.',
'settings_passwordHistory' => 'Passwort-Historie',
'settings_passwordHistory_desc' => 'Die Zahl der Passwörter, die ein Benutzer verwendet hat, bevor er ein altes Passwort wiederverwenden darf. 0 schaltet die Passwort-Historie aus.',
'settings_passwordStrength' => 'Min. Passwortstärke',
'settings_passwordStrengthAlgorithm' => 'Algorithmus für Passwortstärke',
'settings_passwordStrengthAlgorithm_desc' => 'Der Algorithmus zur Berechnung der Passwortstärke. Der \'einfache\' Algorithmus  überprüft lediglich auf mindestens einen Kleinbuchstaben, einen Großbuchstaben, eine Zahl, ein Sonderzeichen und eine Mindestlänge von 8.',
'settings_passwordStrengthAlgorithm_valadvanced' => 'komplex',
'settings_passwordStrengthAlgorithm_valsimple' => 'einfach',
'settings_passwordStrength_desc' => 'Die minimale Passwortstärke ist ein ganzzahliger werden zwischen 0 und 100. Ein Wert von 0 schaltet die Überprüfung auf starke Passwörter aus.',
'settings_pear_log' => 'Pear package : Log',
'settings_pear_webdav' => 'Pear package : HTTP_WebDAV_Server',
'settings_perms' => 'Berechtigungen',
'settings_php_dbDriver' => 'PHP extension : php_\'see current value\'',
'settings_php_gd2' => 'PHP-Erweiterung: php_gd2',
'settings_php_mbstring' => 'PHP-Erweiterung: php_mbstring',
'settings_php_version' => 'PHP Version',
'settings_presetExpirationDate' => 'Voreingestelltes Ablaufdatum',
'settings_presetExpirationDate_desc' => 'Alle neu hochgeladenen Dokumente bekommen das eingegebene Datum als Ablaufdatum. Das Datum muss der Form entsprechen, wie es von der PHP-Funktion strtotime() verstanden wird, z.B. +5 weeks.',
'settings_previewWidthDetail' => 'Breite der Vorschaubilder (Detail)',
'settings_previewWidthDetail_desc' => 'Breite des Vorschaubildes, das auf der Detailseite angezeigt wird',
'settings_previewWidthDropFolderList' => 'Breite der Vorschaubilder (Ablageordner)',
'settings_previewWidthDropFolderList_desc' => 'Setzt die Breite der Vorschaubilder in der Auswahlliste für die Dateien des Ablageordners.',
'settings_previewWidthList' => 'Breite der Vorschaubilder (Liste)',
'settings_previewWidthList_desc' => 'Breite der Vorschaubilder, die in Listen angezeigt werden',
'settings_previewWidthMenuList' => 'Breite der Vorschaubilder (Menu)',
'settings_previewWidthMenuList_desc' => 'Setzt die Breite der Bilder im Menu der Dateien im Ablageordner.',
'settings_printDisclaimer' => 'Rechtliche Hinweise',
'settings_printDisclaimer_desc' => 'Anwählen, um die rechtlichen Hinweise am Ende jeder Seite anzuzeigen.',
'settings_proxyUPassword' => 'Passwort für Proxy',
'settings_proxyUPassword_desc' => 'Passwort für die Authentifizierung am Proxy',
'settings_proxyUrl' => 'URL des Proxy',
'settings_proxyUrl_desc' => 'URL des Proxy welcher für Zugriffe auf das Extension-Repository verwendet wird.',
'settings_proxyUser' => 'Benutzername für Proxy',
'settings_proxyUser_desc' => 'Benutzername zur Authentifizierung am Proxy',
'settings_quota' => 'User\'s quota',
'settings_quota_desc' => 'Die maximale Anzahl Bytes, die ein Benutzer belegen darf. Setzen Sie diesen Wert auf 0 für unbeschränkten Plattenplatz. Dieser Wert kann individuell in den Benutzereinstellungen überschrieben werden.',
'settings_removeFromDropFolder' => 'Datei aus Ablageordner nach erfolgreichem Hochladen löschen',
'settings_removeFromDropFolder_desc' => 'Schalten Sie dies ein, wenn eine Datei aus dem Ablageordner nach erfolgreichem Hochladen gelöscht werden soll.',
'settings_repositoryUrl' => 'URL des Repositoriums',
'settings_repositoryUrl_desc' => 'URL des Repositoriums für Erweiterungen',
'settings_restricted' => 'Beschränkter Zugriff',
'settings_restricted_desc' => 'Nur Benutzer, die einen Eintrag in der Benutzerdatenbank haben dürfen sich anmelden (unabhängig von einer erfolgreichen Authentifizierung über LDAP)',
'settings_rootDir' => 'Wurzelverzeichnis',
'settings_rootDir_desc' => 'Wurzelverzeichnis von SeedDMS auf der Festplatte',
'settings_rootFolderID' => 'Id des Wurzelordners',
'settings_rootFolderID_desc' => 'Id des Wurzelordners in SeedDMS (kann in der Regel unverändert bleiben)',
'settings_SaveError' => 'Fehler beim Speichern der Konfiguration',
'settings_Server' => 'Server-Einstellungen',
'settings_showFullPreview' => 'Zeige gesamtes Dokument',
'settings_showFullPreview_desc' => 'Anwählen, um auf der Dokumenten-Detail-Seite eine vollständige Vorschau des Dokuments anzuzeigen, sofern dies im Browser möglich ist.',
'settings_showMissingTranslations' => 'Zeige fehlende Übersetzungen',
'settings_showMissingTranslations_desc' => 'Listet die fehlenden Übersetzungen der Seite unterhalb der Fußzeile und erlaubt dem Benutzer Vorschläge einzureichen. Diese Vorschläge werden in einer CSV-Datei gespeichert. Diese Funktion sollte nicht in Produktionssystemen eingeschaltet sein.',
'settings_showSingleSearchHit' => 'Springe direkt zu einem einzelnen Suchtreffer',
'settings_showSingleSearchHit_desc' => 'Wenn die Suche nur einen Treffer liefert, dann wird dieser direkt angezeigt und nicht die Liste der Treffer.',
'settings_Site' => 'Site',
'settings_siteDefaultPage' => 'Startseite',
'settings_siteDefaultPage_desc' => 'Erste Seite nach der Anmeldung. Voreingestellt ist \'out/out.ViewFolder.php\'',
'settings_siteName' => 'Name der Site',
'settings_siteName_desc' => 'Name der Site zur Anzeige in Seitentiteln. Voreingestellt ist \'SeedDMS\'',
'settings_SMTP' => 'SMTP Server-Einstellungen',
'settings_smtpPassword' => 'SMTP Server password',
'settings_smtpPassword_desc' => 'SMTP Server password',
'settings_smtpPort' => 'SMTP Server Port',
'settings_smtpPort_desc' => 'SMTP Server Port, voreingestellt ist 25',
'settings_smtpSendFrom' => 'Absenderadresse',
'settings_smtpSendFrom_desc' => 'Absenderadresse für herausgehende E-Mails',
'settings_smtpSendTestMail' => 'Sende Test-E-Mail',
'settings_smtpSendTestMail_desc' => 'Verschickte eine Test-E-Mail, um die akuelle Konfiguration zu testen.',
'settings_smtpServer' => 'SMTP Server-Hostname',
'settings_smtpServer_desc' => 'SMTP Server-Hostname',
'settings_smtpUser' => 'SMTP Server User',
'settings_smtpUser_desc' => 'SMTP Server User',
'settings_sortFoldersDefault' => 'Voreingestellte Sortiermethode',
'settings_sortFoldersDefault_desc' => 'Setzt die Sortiermethode für Ordner und Dokumente in der Ordneransicht.',
'settings_sortFoldersDefault_val_name' => 'nach Name',
'settings_sortFoldersDefault_val_sequence' => 'nach Folge',
'settings_sortFoldersDefault_val_unsorted' => 'unsortiert',
'settings_sortUsersInList' => 'Sortiere Benutzer in Listen',
'settings_sortUsersInList_desc' => 'Stellt ein, ob die Benutzer in Listen nach Login oder Name sortiert werden sollen.',
'settings_sortUsersInList_val_fullname' => 'Sortiere nach Name',
'settings_sortUsersInList_val_login' => 'Sortiere nach Login',
'settings_stagingDir' => 'Verzeichnis für partielle Uploads',
'settings_stagingDir_desc' => 'Das Verzeichnis in dem der jumploader die Teile eines Datei-Uploads hochläd, bevor sie wieder zusammengesetzt werden.',
'settings_start_install' => 'Installation starten',
'settings_stopWordsFile' => 'Pfad zur Stop-Wort-Datei',
'settings_stopWordsFile_desc' => 'Wenn die Volltextsuche aktiviert ist, dann beinhaltet diese Datei ein Liste mit Wörtern die nicht indiziert werden.',
'settings_strictFormCheck' => 'Genauer Formular-Check',
'settings_strictFormCheck_desc' => 'Genaue Formularprüfung. Wenn dies eingeschaltet wird, dann werden alle Felder einiger Formulare auf einen Wert überprüft, anderenfalls sind einige Eingabefelder optional. Ein Kommentar ist beim Prüfen oder Freigeben eines Dokuments oder einer Statusänderung immer notwendig.',
'settings_suggestionvalue' => 'Vorgeschlagener Wert',
'settings_System' => 'System',
'settings_tasksInMenu' => 'Ausgewähtlte Aufgaben',
'settings_tasksInMenu_approval' => 'Freigaben',
'settings_tasksInMenu_checkedout' => 'Ausgechecked',
'settings_tasksInMenu_desc' => 'Setzt die Aufgaben, die gezählt werden sollen. Wenn keine Aufgaben ausgewählt werden, werden alle gezählt.',
'settings_tasksInMenu_needscorrection' => 'Korrektur erforderlich',
'settings_tasksInMenu_receipt' => 'Empfangsbestätigungen',
'settings_tasksInMenu_rejected' => 'Abgelehnt',
'settings_tasksInMenu_review' => 'Prüfungen',
'settings_tasksInMenu_revision' => 'Wiederholungsprüfungen',
'settings_tasksInMenu_workflow' => 'Workflow',
'settings_theme' => 'Aussehen',
'settings_theme_desc' => 'Voreingestelltes Aussehen (Name des Unterordners \'styles\')',
'settings_titleDisplayHack' => 'Title Display Hack',
'settings_titleDisplayHack_desc' => 'Workaround for page titles that go over more than 2 lines.',
'settings_undelUserIds' => 'Nicht löschbare Benutzer-IDs',
'settings_undelUserIds_desc' => 'Komma-separierte Liste von Benutzer-IDs, die nicht gelöscht werden können.',
'settings_updateDatabase' => 'Datenbank-Update-Skript ausführen',
'settings_updateNotifyTime' => 'Update Notify Time',
'settings_updateNotifyTime_desc' => 'Users are notified about document-changes that took place within the last \'Update Notify Time\' seconds',
'settings_upgrade_php' => 'Aktualisiere PHP auf mindestens version 5.6.38',
'settings_useHomeAsRootFolder' => 'Benutze Home-Ordner als Wurzelordner',
'settings_useHomeAsRootFolder_desc' => 'Wenn dies eingeschaltet ist, wird der Home-Ordner eines Benutzer (kein Admin) als Wurzelordner verwendet (experimentell).',
'settings_versioningFileName' => 'Versionsinfo-Datei',
'settings_versioningFileName_desc' => 'Der Name der Datei mit Versionsinformationen, wie sie durch das Backup-Tool erzeugt werden.',
'settings_versiontolow' => 'Version zu gering',
'settings_viewOnlineFileTypes' => 'Dateitypen für Online-Ansicht',
'settings_viewOnlineFileTypes_desc' => 'Dateien mit den angegebenen Endungen können Online angeschaut werden (benutzen Sie ausschließlich Kleinbuchstaben).',
'settings_webdav' => 'WebDAV',
'settings_workflowMode' => 'Workflow mode',
'settings_workflowMode_desc' => 'Der erweiterte Workflow-Modes erlaubt es eigene Workflows zu erstellen.',
'settings_workflowMode_valadvanced' => 'erweitert',
'settings_workflowMode_valnone' => 'keiner',
'settings_workflowMode_valtraditional' => 'traditionell',
'settings_workflowMode_valtraditional_only_approval' => 'traditional (ohne Prüfung)',
'settings_zendframework' => 'Zend Framework',
'set_expiry' => 'Ablaufdatum festlegen',
'set_owner' => 'Besitzer festlegen',
'set_owner_error' => 'Fehler beim Setzen des Besitzers',
'set_password' => 'Passwort setzen',
'set_workflow' => 'Workflow zuweisen',
'show_extension_changelog' => 'Zeige Versionshistorie',
'show_extension_version_list' => 'Zeige Liste der Versionen',
'signed_in_as' => 'Angemeldet als',
'sign_in' => 'Anmelden',
'sign_out' => 'Abmelden',
'sign_out_user' => 'Benutzer abmelden',
'site_brand' => '',
'sk_SK' => 'Slovakisch',
'sort_by_date' => 'Nach Datum sortieren',
'sort_by_expiration_date' => 'Nach Ablaufdatum sortieren',
'sort_by_name' => 'Nach Name sortieren',
'sort_by_sequence' => 'Nach Reihenfolge sortieren',
'space_used_on_data_folder' => 'Benutzter Plattenplatz',
'splash_added_to_clipboard' => 'Der Zwischenablage hinzugefügt',
'splash_add_access' => 'Neues Zugriffsrecht hinzugefügt',
'splash_add_attribute' => 'Neues Attribut hinzugefügt',
'splash_add_group' => 'Neue Gruppe hinzugefügt',
'splash_add_group_member' => 'Neues Gruppenmitglied hinzugefügt',
'splash_add_notify' => 'Neue Benachrichtigung hinzugefügt',
'splash_add_role' => 'Neue Rolle hinzugefügt',
'splash_add_task' => 'Neuer Task hinzugefügt',
'splash_add_to_transmittal' => 'Zur Dokumentenliste hinzugefügt',
'splash_add_transmittal' => 'Neue Dokumentenliste angelegt',
'splash_add_user' => 'Neuen Benutzer hinzugefügt',
'splash_cancel_checkout' => 'Auschecken abgebrochen',
'splash_cleared_cache' => 'Cache geleert',
'splash_cleared_clipboard' => 'Zwischenablage geleert',
'splash_delete_access' => 'Zugriffsrecht gelöscht',
'splash_document_added' => 'Dokument hinzugefügt',
'splash_document_checkedout' => 'Dokument ausgecheckt',
'splash_document_deleted' => 'Dokument gelöscht',
'splash_document_edited' => 'Dokument gespeichert',
'splash_document_indexed' => 'Dokument \'[name]\' indiziert.',
'splash_document_locked' => 'Dokument gesperrt',
'splash_document_name_changed' => 'Dokumentenname geändert',
'splash_document_unlocked' => 'Dokumentensperre aufgehoben',
'splash_edit_access' => 'Zugriffsrecht verändert',
'splash_edit_attribute' => 'Attribut gespeichert',
'splash_edit_event' => 'Ereignis gespeichert',
'splash_edit_group' => 'Gruppe gespeichert',
'splash_edit_role' => 'Rolle gespeichert',
'splash_edit_task' => 'Task gespeichert',
'splash_edit_transmittal' => 'Dokumentenliste gespeichert',
'splash_edit_user' => 'Benutzer gespeichert',
'splash_error_add_to_transmittal' => 'Fehler beim Hinzufügen zur Dokumentenliste',
'splash_error_rm_download_link' => 'Fehler beim Löschen des Download-Links',
'splash_error_saving_file' => 'Fehler beim Speichern der Datei',
'splash_error_send_download_link' => 'Fehler beim Verschicken des Download-Links',
'splash_expiration_date_cleared' => 'Ablaufdatum gelöscht',
'splash_expiration_date_set' => 'Ablaufdatum auf [date] gesetzt',
'splash_extension_getlist' => 'Liste der Erweiterungen im Repositorium aktualisiert.',
'splash_extension_import' => 'Erweiterung installiert',
'splash_extension_refresh' => 'Liste der Erweiterungen neu geladen',
'splash_extension_upload' => 'Erweiterung installiert',
'splash_folder_deleted' => 'Ordner gelöscht',
'splash_folder_edited' => 'Änderungen am Ordner gespeichert',
'splash_importfs' => '[docs] Dokumente und [folders] Ordner importiert',
'splash_inherit_access' => 'Zugriffsrechte werden geerbt',
'splash_invalid_folder_id' => 'Ungültige Ordner-ID',
'splash_invalid_searchterm' => 'Ungültiger Suchbegriff',
'splash_invalid_search_service' => 'Ungültiger Suchdienst',
'splash_link_document' => 'Link hinzugefügt',
'splash_moved_clipboard' => 'Inhalt der Zwischenablage in aktuellen Ordner verschoben',
'splash_move_document' => 'Dokument verschoben',
'splash_move_folder' => 'Ordner verschoben',
'splash_notinherit_access' => 'Zugriffsrechte werden nicht mehr geerbt',
'splash_receipt_update_success' => 'Empfangsbestätigung hinzugefügt',
'splash_removed_from_clipboard' => 'Aus der Zwischenablage entfernt',
'splash_rm_attribute' => 'Attribut gelöscht',
'splash_rm_attr_value' => 'Attributwert entfernt',
'splash_rm_document' => 'Dokument gelöscht',
'splash_rm_download_link' => 'Download-Link gelöscht',
'splash_rm_folder' => 'Ordner gelöscht',
'splash_rm_group' => 'Gruppe gelöscht',
'splash_rm_group_member' => 'Mitglied der Gruppe gelöscht',
'splash_rm_notify' => 'Benachrichtigung gelöscht',
'splash_rm_role' => 'Rolle gelöscht',
'splash_rm_transmittal' => 'Dokumentenliste gelöscht',
'splash_rm_user' => 'Benutzer gelöscht',
'splash_rm_user_processes' => 'Benutzer aus allen Prozessen gelöscht',
'splash_rm_workflow' => 'Workflow gelöscht',
'splash_rm_workflow_action' => 'Workflow-Aktion gelöscht',
'splash_rm_workflow_state' => 'Workflow-Status gelöscht',
'splash_saved_file' => 'Version gespeichert',
'splash_save_user_data' => 'Benutzerdaten gespeichert',
'splash_send_download_link' => 'Download-Link per E-Mail verschickt.',
'splash_send_login_data' => 'Login-Daten verschickt',
'splash_setowner' => 'Neuen Besitzer gesetzt',
'splash_settings_saved' => 'Einstellungen gesichert',
'splash_set_default_access' => 'Default-Zugriffsrecht gesetzt',
'splash_substituted_user' => 'Benutzer gewechselt',
'splash_switched_back_user' => 'Zum ursprünglichen Benutzer zurückgekehrt',
'splash_toogle_group_manager' => 'Gruppenverwalter gewechselt',
'splash_transfer_content' => 'Dokumenteninhalt übertragen',
'splash_transfer_document' => 'Dokument übertragen',
'splash_transfer_objects' => 'Objekte übertragen',
'splash_trigger_workflow' => '',
'state_and_next_state' => 'Status/Nächster Status',
'statistic' => 'Statistik',
'status' => 'Status',
'status_approval_rejected' => 'abgelehnt',
'status_approved' => 'freigegeben',
'status_approver_removed' => 'Freigebender wurde vom Prozess ausgeschlossen',
'status_change' => 'Statusänderung',
'status_needs_correction' => 'Korrektur erforderlich',
'status_not_approved' => 'keine Freigabe',
'status_not_receipted' => 'Empfang noch nicht bestätigt',
'status_not_reviewed' => 'nicht geprüft',
'status_not_revised' => 'nicht überprüft',
'status_receipted' => 'Empfang bestätigt',
'status_receipt_rejected' => 'Abgelehnt',
'status_recipient_removed' => 'Empfänger aus Liste entfernt',
'status_reviewed' => 'geprüft',
'status_reviewer_rejected' => 'abgelehnt',
'status_reviewer_removed' => 'Prüfer wurde vom Prozess ausgeschlossen',
'status_revised' => 'überprüft',
'status_revision_rejected' => 'Abgelehnt',
'status_revision_sleeping' => 'wartend',
'status_revisor_removed' => 'Wiederholungsprüfer von Liste entfernt',
'status_unknown' => 'unbekannt',
'storage_size' => 'Speicherverbrauch',
'subfolder_duplicate_name' => 'Doppelter Unterordnername',
'submit_2_fact_auth' => 'Schlüssel speichern',
'submit_approval' => 'Freigabe hinzufügen',
'submit_login' => 'Anmelden',
'submit_password' => 'Setze neues Passwort',
'submit_password_forgotten' => 'Neues Passwort setzen und per E-Mail schicken',
'submit_receipt' => 'Empfang bestätigen',
'submit_review' => 'Prüfung hinzufügen',
'submit_revision' => 'Wiederholungsprüfung hinzufügen',
'submit_userinfo' => 'Daten setzen',
'submit_webauthn_login' => '',
'submit_webauthn_register' => '',
'subsribe_timelinefeed' => 'Verlauf als RSS-Feed abonnieren',
'substitute_to_user' => 'Wechsel zu \'[username]\'',
'substitute_user' => 'Benutzer wechseln',
'success_add_aro' => 'Zugriffsobjekt hinzugefügt',
'success_add_permission' => 'Berechtigung hinzugefügt',
'success_remove_permission' => 'Berechtigung entfernt',
'success_toogle_permission' => 'Berechtigung geändert',
'sunday' => 'Sonntag',
'sunday_abbr' => 'So',
'sv_SE' => 'Schwedisch',
'switched_to' => 'Gewechselt zu',
'takeOverAttributeValue' => 'Attributwert von vorheriger Version übernehmen',
'takeOverGrpApprover' => 'Übernehme Gruppe von Freigebenden von letzter Version.',
'takeOverGrpApprovers' => 'Gruppenfreigeber übernehmen',
'takeOverGrpReviewer' => 'Übernehme Gruppe von Prüfern von letzter Version.',
'takeOverGrpReviewers' => 'Gruppenprüfer übernehmen',
'takeOverIndApprover' => 'Übernehme Einzelfreigebende von letzter Version.',
'takeOverIndApprovers' => 'Einzelfreigeber übernehmen',
'takeOverIndReviewer' => 'Übernehme die Einzelprüfer von der letzten Version.',
'takeOverIndReviewers' => 'Einzelprüfer übernehmen',
'target_equals_source_folder' => 'Zielordner ist identisch zu Quellordner',
'tasks' => 'Aufgaben',
'task_core_expireddocs_days' => 'Tage',
'task_core_expireddocs_email' => 'E-Mail',
'task_core_expireddocs_peruser' => 'Pro Benutzer',
'task_core_indexingdocs_recreate' => 'Index neu erzeugen',
'task_description' => 'Beschreibung',
'task_disabled' => 'Deaktiviert',
'task_frequency' => 'Häufigkeit',
'task_frequency_placeholder' => 'm h d m dow',
'task_last_run' => 'Letzte Ausführung',
'task_name' => 'Name',
'task_next_run' => 'Nächste Ausführung',
'temp_jscode' => 'Temporärer Javascript-Code',
'testmail_body' => 'Diese Mail ist lediglich zum Test der E-Mail-Konfiguration von SeedDMS',
'testmail_subject' => 'Test Mail',
'theme' => 'Aussehen',
'thursday' => 'Donnerstag',
'thursday_abbr' => 'Do',
'timeline' => 'Verlauf',
'timeline_add_file' => 'Neuer Anhang',
'timeline_add_version' => 'Neue Version [version]',
'timeline_full_add_file' => '[document]<br />Neuer Anhang',
'timeline_full_add_version' => '[document]<br />Neue Version [version]',
'timeline_full_scheduled_revision' => '[document]<br />Wiederholungsprüfung von Version [version]',
'timeline_full_status_change' => '[document]<br />Version [version]: [status]',
'timeline_scheduled_revision' => 'Wiederholungsprüfung von Version [version]',
'timeline_selected_item' => 'Ausgewähltes Dokument',
'timeline_skip_add_file' => 'Anhang hinzugefügt',
'timeline_skip_scheduled_revision' => 'Geplante Wiederholungsprüfung',
'timeline_skip_status_change_-1' => 'abgelehnt',
'timeline_skip_status_change_-2' => 'veraltet',
'timeline_skip_status_change_-3' => 'abgelaufen',
'timeline_skip_status_change_0' => 'Prüfung erforderlich',
'timeline_skip_status_change_1' => 'Freigabe erforderlich',
'timeline_skip_status_change_2' => 'freigegeben',
'timeline_skip_status_change_3' => 'im Workflow',
'timeline_skip_status_change_4' => 'Wiederholungsprüfung erforderlich',
'timeline_skip_status_change_5' => 'Entwurf',
'timeline_status_change' => 'Version [version]: [status]',
'to' => 'bis',
'toggle_manager' => 'Managerstatus wechseln',
'toggle_qrcode' => 'Zeige/verberge QR-Code',
'total' => 'Gesamt',
'to_before_from' => 'Endedatum darf nicht vor dem Startdatum liegen',
'transfer_content' => 'Inhalt übertragen',
'transfer_document' => 'Dokument übertragen',
'transfer_no_read_access' => 'Der Benutzer hat in dem Ordner keine Schreibrechte',
'transfer_no_users' => 'Es existieren zur Zeit keine Benutzer auf die dieses Dokument übertragen werden kann.',
'transfer_no_write_access' => 'Der Benutzer hat in dem Ordner keine Schreibrechte',
'transfer_objects' => 'Objekte übertragen',
'transfer_objects_to_user' => 'Neuer Eigentümer',
'transfer_process_to_user' => 'Prozess auf Benutzer übertragen',
'transfer_to_user' => 'Auf Benutzer übertragen',
'transition_triggered_email' => 'Workflow transition triggered',
'transition_triggered_email_body' => 'Workflow Statusübergang ausgelöst

Dokument: [name]
Version: [version]
Kommentar: [comment]
Workflow: [workflow]
Vorheriger Status: [previous_state]
Akuteller Status: [current_state]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'transition_triggered_email_body_html' => '<p>Workflow Statusübergang ausgelöst.</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Kommentar: [comment]<br />
Workflow: [workflow]<br />
Vorheriger Status: [previous_state]<br />
Aktueller Status: [current_state]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'transition_triggered_email_subject' => '[sitename]: [name] - Workflow transition triggered',
'transmittal' => 'Dokumentenliste',
'transmittalitem_removed' => 'Eintrag aus Dokumentenliste gelöscht',
'transmittalitem_updated' => 'Dokument auf neueste Version aktualisiert',
'transmittal_comment' => 'Kommentar',
'transmittal_name' => 'Name',
'transmittal_size' => 'Größe',
'tree_loading' => 'Bitte warten, bis der Dokumentenbaum geladen ist …',
'trigger_workflow' => 'Workflow',
'tr_TR' => 'Türkisch',
'tuesday' => 'Dienstag',
'tuesday_abbr' => 'Di',
'types_generic' => 'Generische Typen',
'type_of_hook' => 'Typ',
'type_to_filter' => 'Hier tippen zum Filtern der Liste',
'type_to_search' => 'Hier tippen zum Suchen',
'uk_UA' => 'Ukrainisch',
'under_folder' => 'In Ordner',
'unknown_attrdef' => 'unbekannte Attributdefinition',
'unknown_command' => 'unbekannter Befehl',
'unknown_document_category' => 'unbekannte Kategorie',
'unknown_group' => 'unbekannte Gruppenidentifikation',
'unknown_id' => 'unbekannte id',
'unknown_keyword_category' => 'unbekannte Kategorie',
'unknown_owner' => 'unbekannte Besitzeridentifikation',
'unknown_status' => 'unbekannter Status',
'unknown_user' => 'unbekannte Benutzeridentifikation',
'unlinked_content' => 'Dokumenteninhalt ohne Dokument',
'unlinked_documents' => 'Nicht verknüpfte Dokumente',
'unlinked_folders' => 'Lose Ordner',
'unlinking_objects' => 'Lösche verwaiste Objekte',
'unlock_cause_access_mode_all' => 'Sie verfügen jedoch über unbeschränken Zugriff auf dieses Dokument.<br>Daher wird die Sperrung beim Update automatisch aufgehoben',
'unlock_cause_locking_user' => 'Sie sind im Moment mit demselben Benutzer angemeldet.<br>Daher wird die Sperrung beim Update automatisch aufgehoben',
'unlock_document' => 'Sperrung aufheben',
'update' => 'Aktualisieren',
'update_approvers' => 'Liste der Freigebenden aktualisieren',
'update_document' => 'Aktualisieren',
'update_fulltext_index' => 'Aktualisiere Volltext-Index',
'update_info' => 'Informationen zur Aktualisierung',
'update_locked_msg' => 'Dieses Dokument wurde gesperrt<p>Die Sperrung wurde von <a href="mailto:[email]">[username]</a> eingerichtet.<br>',
'update_recipients' => 'Liste der Empfänger aktualisieren',
'update_reviewers' => 'Liste der Prüfer aktualisieren',
'update_revisors' => 'Liste der Wiederholungsprüfer ändern',
'update_transmittalitem' => 'Auf neueste Dokumentenversion aktualisieren',
'uploaded_by' => 'Hochgeladen durch',
'uploading_failed' => 'Das Hochladen einer Datei ist fehlgeschlagen. Bitte überprüfen Sie die maximale Dateigröße für Uploads.',
'uploading_maxsize' => 'Die Datei überschreitet die maximale Dateigröße für Uploads.',
'uploading_postmaxsize' => 'Der Post-Request überschreitet die maximal Größe.',
'uploading_zerosize' => 'Versuch eine leere Datei hochzuladen. Vorgang wird abgebrochen.',
'used_discspace' => 'Verbrauchter Speicherplatz',
'user' => 'Benutzer',
'userdata_file' => 'Benutzerdaten',
'userid_groupid' => 'Benutzer-ID/Gruppen-ID',
'users' => 'Benutzer',
'users_and_groups' => 'Benutzer/Gruppen',
'users_done_work' => 'Bereits aktive Benutzer',
'user_exists' => 'Benutzer besteht bereits.',
'user_group' => 'Benutzer/Gruppe',
'user_group_management' => 'Benutzer-/Gruppenmanagement',
'user_image' => 'Bild',
'user_info' => 'Benutzerinformation',
'user_list' => 'Benutzerübersicht',
'user_login' => 'Benutzername',
'user_management' => 'Benutzerverwaltung',
'user_name' => 'Vollst. Name',
'use_comment_of_document' => 'Verwende Kommentar des Dokuments',
'use_default_categories' => 'Kategorievorlagen',
'use_default_keywords' => 'Stichwortvorlagen',
'valid_till' => 'Gültig bis',
'version' => 'Version',
'versioning_file_creation' => 'Datei-Versionierung',
'versioning_file_creation_warning' => 'Mit dieser Operation erzeugen Sie pro Dokument eine Datei, die sämtliche Versions-Informationen des Dokuments enthält. Nach Erstellung wird jede Datei im Dokumentenverzeichnis gespeichert. Die erzeugten Dateien sind für den regulären Betrieb nicht erforderlich. Sie können aber von Nutzen sein, wenn der Dokumentenbestand auf ein anderes System übertragen werden soll.',
'versioning_info' => 'Versionsinformationen',
'versiontolow' => 'Version zu niedrig',
'version_comment' => 'Kommentar der Version',
'version_deleted_email' => 'Version gelöscht',
'version_deleted_email_body' => 'Version gelöscht

Dokument: [name]
Version: [version]
Elternordner: [folder_path]
Benutzer: [username]
URL: [url]',
'version_deleted_email_body_html' => '<p>Version gelöscht</p>

<p>Dokument: [name]<br />
Version: [version]<br />
Elternordner: [folder_path]<br />
Benutzer: [username]<br />
URL: [url]</p>',
'version_deleted_email_subject' => '[sitename]: [name] - Version gelöscht',
'version_info' => 'Versionsinformation',
'view' => 'Ansicht',
'view_document' => 'Dokumentendetails anzeigen',
'view_folder' => 'Ordnerdetails anzeigen',
'view_online' => 'Online betrachten',
'warning' => 'Warnung',
'warning_remove_approval_log' => 'Das Entfernen einer bestehenden Freigabe kann nicht rückgängig gemacht werden und wird nicht protokoliert.',
'warning_remove_review_log' => 'Das Entfernen einer bestehenden Prüfung kann nicht rückgängig gemacht werden und wird nicht protokoliert.',
'webauthn_auth' => 'WebAuthn Authentifizierung',
'webauthn_crossplatform_info' => '',
'webauthn_info' => '',
'webauth_crossplatform' => '',
'wednesday' => 'Mitwoch',
'wednesday_abbr' => 'Mi',
'weeks' => 'Wochen',
'week_view' => 'Wochenansicht',
'workflow' => 'Workflow',
'workflows_involded' => 'Beteiligt an Workflow',
'workflow_actions_management' => 'Workflow-Aktions-Management',
'workflow_action_in_use' => 'Diese Aktion wird zur Zeit von Workflows benutzt',
'workflow_action_name' => 'Name',
'workflow_editor' => 'Workflow Editor',
'workflow_group_summary' => 'Gruppenübersicht',
'workflow_has_cycle' => 'Workflow hat Zyklus',
'workflow_initstate' => 'Initialer Status',
'workflow_in_use' => 'Dieser Workflow wird zur Zeit noch von einem Dokument verwendet.',
'workflow_layoutdata_saved' => 'Layout-Daten gespeichert',
'workflow_log' => 'Workflow Protokoll',
'workflow_management' => 'Workflow-Management',
'workflow_name' => 'Name',
'workflow_no_doc_rejected_state' => 'Das Dokument wird in keinem Workflow-Status abgelehnt!',
'workflow_no_doc_released_state' => 'Das Dokument wird in keinem Workflow-Status freigegeben!',
'workflow_no_initial_state' => 'Keine Transition beginnt mit dem initialen Status des Workflows!',
'workflow_no_states' => 'Es muss zunächst mindestens ein Workflow-Status angelegt werden, um einen Workflow anlegen zu können.',
'workflow_save_layout' => 'Layout speichern',
'workflow_state' => 'Workflow-Status',
'workflow_states_management' => 'Workflow-Status-Management',
'workflow_state_docstatus' => 'Dokumentenstatus',
'workflow_state_in_use' => 'Dieser Status wird zur Zeit von einem Workflow verwendet.',
'workflow_state_name' => 'Name',
'workflow_summary' => 'Übersicht Workflows',
'workflow_title' => '',
'workflow_transition_without_user_group' => 'Mindestens eine Transition hat weder einen Benutzer noch eine Gruppe zugewiesen!',
'workflow_user_summary' => 'Übersicht Benutzer',
'wrong_checksum' => 'Falsche Prüfsumme',
'wrong_filetype' => 'Falscher Dateityp',
'x_more_objects' => '[number] weitere Objekte',
'year_view' => 'Jahresansicht',
'yes' => 'Ja',
'zh_CN' => 'Chinesisch (CN)',
'zh_TW' => 'Chinesisch (TW)',
);
?>
